/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.imap.ImapServiceImpl;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class ExtendedImapServiceImpl
extends ImapServiceImpl {
    private NodeService nodeService;
    private BehaviourFilter policyBehaviourFilter;
    private DictionaryService dictionaryService;
    private AuthenticationUtil authenticationUtil;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public void setPolicyFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
        super.setPolicyFilter(policyBehaviourFilter);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
        super.setNodeService(nodeService);
    }

    public String getPathFromSites(final NodeRef ref) {
        return this.doAsSystem(new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                String name = ((String)((Object)ExtendedImapServiceImpl.this.nodeService.getProperty(ref, ContentModel.PROP_NAME))).toLowerCase();
                if (ExtendedImapServiceImpl.this.dictionaryService.isSubClass(ExtendedImapServiceImpl.this.nodeService.getType(ref), SiteModel.TYPE_SITE)) {
                    return name;
                }
                NodeRef parent = ExtendedImapServiceImpl.this.nodeService.getPrimaryParent(ref).getParentRef();
                return ExtendedImapServiceImpl.this.getPathFromSites(parent) + "/" + name;
            }
        });
    }

    private <R> R doAsSystem(AuthenticationUtil.RunAsWork<R> work) {
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            R r = this.authenticationUtil.runAsSystem(work);
            return r;
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
    }
}

