/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.script.slingshot.ClassificationReasonsUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ClassificationReasonsUtilUnitTest {
    @Mock
    private NodeService nodeService;
    @Mock
    private ChildAssociationRef childAssociationRef;
    @Mock
    private ChildAssociationRef reason;
    @Mock
    private Map<QName, Serializable> properties;
    @InjectMocks
    private ClassificationReasonsUtil classificationReasonsUtil;
    private NodeRef childNodeRef;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        NodeRef rootNodeRef = new NodeRef("workspace://SpacesStore/rootNodeRef");
        NodeRef containerNodeRef = new NodeRef("workspace://SpacesStore/containerNodeRef");
        this.childNodeRef = new NodeRef("workspace://SpacesStore/childNodeRef");
        ArrayList<ChildAssociationRef> assocRefs = new ArrayList<ChildAssociationRef>();
        ArrayList<ChildAssociationRef> childAssocRefs = new ArrayList<ChildAssociationRef>();
        assocRefs.add(this.childAssociationRef);
        childAssocRefs.add(this.reason);
        Mockito.when((Object)this.reason.getChildRef()).thenReturn((Object)this.childNodeRef);
        Mockito.when((Object)this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE)).thenReturn((Object)rootNodeRef);
        Mockito.when((Object)this.nodeService.getChildAssocs(rootNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)ClassificationReasonsUtil.CLASSIFICATION_REASONS_CONTAINER)).thenReturn(assocRefs);
        Mockito.when((Object)this.childAssociationRef.getChildRef()).thenReturn((Object)containerNodeRef);
        Mockito.when((Object)this.nodeService.getChildAssocs(containerNodeRef)).thenReturn(childAssocRefs);
    }

    @Test
    public void testNoChangeMadeToStringIfKeyNotFound() {
        String stringToTest = "noChangeMadeToString";
        Assert.assertEquals((String)"Change made to string", (Object)stringToTest, (Object)this.classificationReasonsUtil.replaceReasonWithNodeRef(stringToTest).trim());
    }

    @Test
    public void testNoChangeMadeToStringIfMatchNotFound() {
        Mockito.when((Object)this.nodeService.getProperties(this.childNodeRef)).thenReturn(this.properties);
        Mockito.when((Object)this.properties.get(ClassificationReasonsUtil.PROP_CLASSIFICATION_REASON_CODE)).thenReturn((Object)"not a match!");
        String stringToTest = "clf:classificationReasons:noChangeMadeToString";
        Assert.assertEquals((String)"Change made to string", (Object)stringToTest, (Object)this.classificationReasonsUtil.replaceReasonWithNodeRef(stringToTest).trim());
    }

    @Test
    public void testChangeMadeToStringIfMatchFound() {
        Mockito.when((Object)this.nodeService.getProperties(this.childNodeRef)).thenReturn(this.properties);
        Mockito.when((Object)this.properties.get(ClassificationReasonsUtil.PROP_CLASSIFICATION_REASON_CODE)).thenReturn((Object)"stringToChange");
        Mockito.when((Object)this.properties.get(ContentModel.PROP_NAME)).thenReturn((Object)"newString");
        String stringToTest = "clf:classificationReasons:stringToChange";
        Assert.assertEquals((String)"No change made to string", (Object)"clf:classificationReasons:newString", (Object)this.classificationReasonsUtil.replaceReasonWithNodeRef(stringToTest).trim());
    }
}

