/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementAction;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionCondition;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionResult;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.util.PoliciesUtil;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class RecordsManagementActionServiceImpl
implements RecordsManagementActionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordsManagementActionServiceImpl.class);
    private static final String MSG_NOT_DEFINED = "rm.action.not-defined";
    private static final String MSG_NO_IMPLICIT_NODEREF = "rm.action.no-implicit-noderef";
    private static final String MSG_NODE_FROZEN = "rm.action.node.frozen.error-message";
    private Map<String, RecordsManagementAction> rmActions = new HashMap<String, RecordsManagementAction>(13);
    private Map<String, RecordsManagementActionCondition> rmConditions = new HashMap<String, RecordsManagementActionCondition>(13);
    private Map<String, RecordsManagementAction> dispositionActions = new HashMap<String, RecordsManagementAction>(5);
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private ClassPolicyDelegate<RecordsManagementPolicies.BeforeRMActionExecution> beforeRMActionExecutionDelegate;
    private ClassPolicyDelegate<RecordsManagementPolicies.OnRMActionExecution> onRMActionExecutionDelegate;
    private FreezeService freezeService;
    private List<String> retentionActions;

    protected PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setFreezeService(FreezeService freezeService) {
        this.freezeService = freezeService;
    }

    public void setRetentionActions(List<String> retentionActions) {
        this.retentionActions = retentionActions;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.beforeRMActionExecutionDelegate = this.getPolicyComponent().registerClassPolicy(RecordsManagementPolicies.BeforeRMActionExecution.class);
        this.onRMActionExecutionDelegate = this.getPolicyComponent().registerClassPolicy(RecordsManagementPolicies.OnRMActionExecution.class);
    }

    @Override
    public void register(RecordsManagementAction rmAction) {
        if (!this.rmActions.containsKey(rmAction.getName())) {
            this.rmActions.put(rmAction.getName(), rmAction);
            if (rmAction.isDispositionAction()) {
                this.dispositionActions.put(rmAction.getName(), rmAction);
            }
        }
    }

    @Override
    public void register(RecordsManagementActionCondition rmCondition) {
        if (!this.rmConditions.containsKey(rmCondition.getBeanName())) {
            this.rmConditions.put(rmCondition.getBeanName(), rmCondition);
        }
    }

    protected void invokeBeforeRMActionExecution(NodeRef nodeRef, String name, Map<String, Serializable> parameters) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.getNodeService(), nodeRef);
        RecordsManagementPolicies.BeforeRMActionExecution policy = (RecordsManagementPolicies.BeforeRMActionExecution)this.beforeRMActionExecutionDelegate.get(qnames);
        policy.beforeRMActionExecution(nodeRef, name, parameters);
    }

    protected void invokeOnRMActionExecution(NodeRef nodeRef, String name, Map<String, Serializable> parameters) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.getNodeService(), nodeRef);
        RecordsManagementPolicies.OnRMActionExecution policy = (RecordsManagementPolicies.OnRMActionExecution)this.onRMActionExecutionDelegate.get(qnames);
        policy.onRMActionExecution(nodeRef, name, parameters);
    }

    @Override
    public List<RecordsManagementAction> getRecordsManagementActions() {
        ArrayList<RecordsManagementAction> result = new ArrayList<RecordsManagementAction>(this.rmActions.size());
        result.addAll(this.rmActions.values());
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<RecordsManagementActionCondition> getRecordsManagementActionConditions() {
        ArrayList<RecordsManagementActionCondition> result = new ArrayList<RecordsManagementActionCondition>(this.rmConditions.size());
        result.addAll(this.rmConditions.values());
        return Collections.unmodifiableList(result);
    }

    public List<RecordsManagementAction> getDispositionActions(NodeRef nodeRef) {
        ArrayList result = new ArrayList(this.rmActions.size());
        for (RecordsManagementAction recordsManagementAction : this.rmActions.values()) {
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<RecordsManagementAction> getDispositionActions() {
        ArrayList<RecordsManagementAction> result = new ArrayList<RecordsManagementAction>(this.dispositionActions.size());
        result.addAll(this.dispositionActions.values());
        return Collections.unmodifiableList(result);
    }

    @Override
    public RecordsManagementAction getDispositionAction(String name) {
        return this.dispositionActions.get(name);
    }

    @Override
    public RecordsManagementAction getRecordsManagementAction(String name) {
        return this.rmActions.get(name);
    }

    @Override
    public RecordsManagementActionResult executeRecordsManagementAction(NodeRef nodeRef, String name) {
        return this.executeRecordsManagementAction(nodeRef, name, null);
    }

    @Override
    public Map<NodeRef, RecordsManagementActionResult> executeRecordsManagementAction(List<NodeRef> nodeRefs, String name) {
        return this.executeRecordsManagementAction(nodeRefs, name, null);
    }

    @Override
    public RecordsManagementActionResult executeRecordsManagementAction(NodeRef nodeRef, String name, Map<String, Serializable> parameters) {
        log.debug("Executing record management action on " + String.valueOf(nodeRef));
        log.debug("    actionName = " + name);
        log.debug("    parameters = " + String.valueOf(parameters));
        RecordsManagementAction rmAction = this.rmActions.get(name);
        if (rmAction == null) {
            String msg = I18NUtil.getMessage((String)MSG_NOT_DEFINED, (Object[])new Object[]{name});
            log.warn(msg);
            throw new AlfrescoRuntimeException(msg);
        }
        if (this.retentionActions.contains(name.toLowerCase()) && this.freezeService.isFrozenOrHasFrozenChildren(nodeRef)) {
            String msg = I18NUtil.getMessage((String)MSG_NODE_FROZEN, (Object[])new Object[]{name});
            log.debug(msg);
            throw new AlfrescoRuntimeException(msg);
        }
        this.invokeBeforeRMActionExecution(nodeRef, name, parameters);
        RecordsManagementActionResult result = rmAction.execute(nodeRef, parameters);
        if (this.getNodeService().exists(nodeRef)) {
            this.invokeOnRMActionExecution(nodeRef, name, parameters);
        }
        return result;
    }

    @Override
    public RecordsManagementActionResult executeRecordsManagementAction(String name, Map<String, Serializable> parameters) {
        RecordsManagementAction rmAction = this.rmActions.get(name);
        NodeRef implicitTargetNode = rmAction.getImplicitTargetNodeRef();
        if (implicitTargetNode == null) {
            String msg = I18NUtil.getMessage((String)MSG_NO_IMPLICIT_NODEREF, (Object[])new Object[]{name});
            log.warn(msg);
            throw new AlfrescoRuntimeException(msg);
        }
        return this.executeRecordsManagementAction(implicitTargetNode, name, parameters);
    }

    @Override
    public Map<NodeRef, RecordsManagementActionResult> executeRecordsManagementAction(List<NodeRef> nodeRefs, String name, Map<String, Serializable> parameters) {
        HashMap<NodeRef, RecordsManagementActionResult> results = new HashMap<NodeRef, RecordsManagementActionResult>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            RecordsManagementActionResult result = this.executeRecordsManagementAction(nodeRef, name, parameters);
            results.put(nodeRef, result);
        }
        return results;
    }
}

