/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.behaviour;

import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.RecordsManagementSearchBehaviour;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public abstract class AbstractDisposableItem
extends BaseBehaviourBean {
    protected QName[] unwantedAspects = new QName[]{ASPECT_VITAL_RECORD, ASPECT_DISPOSITION_LIFECYCLE, RecordsManagementSearchBehaviour.ASPECT_RM_SEARCH};
    protected DispositionService dispositionService;
    protected RecordService recordService;
    protected RecordFolderService recordFolderService;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    protected void cleanDisposableItem(NodeService nodeService, NodeRef nodeRef) {
        for (QName aspect : this.unwantedAspects) {
            if (!nodeService.hasAspect(nodeRef, aspect)) continue;
            nodeService.removeAspect(nodeRef, aspect);
        }
        DispositionAction dispositionAction = this.dispositionService.getNextDispositionAction(nodeRef);
        if (dispositionAction != null) {
            nodeService.deleteNode(dispositionAction.getNodeRef());
        }
    }

    protected void reinitializeRecordFolder(ChildAssociationRef childAssociationRef) {
        NodeRef newNodeRef = childAssociationRef.getChildRef();
        AuthenticationUtil.runAs(() -> {
            this.cleanDisposableItem(this.nodeService, newNodeRef);
            this.recordFolderService.setupRecordFolder(newNodeRef);
            for (NodeRef record : this.recordService.getRecords(newNodeRef)) {
                this.cleanDisposableItem(this.nodeService, record);
                this.recordService.file(record);
            }
            return null;
        }, (String)AuthenticationUtil.getSystemUserName());
    }
}

