/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v35;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.AbstractModulePatch;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMv35HoldNewChildAssocPatch
extends AbstractModulePatch {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RMv35HoldNewChildAssocPatch.class);
    protected static final QName PATCH_ASSOC_NAME = QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)RMv35HoldNewChildAssocPatch.class.getSimpleName());
    private int batchSize = 1000;
    private FilePlanService filePlanService;
    private HoldService holdService;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyInternal() {
        this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            int patchedNodesCounter = 0;
            for (NodeRef filePlan : this.filePlanService.getFilePlans()) {
                for (NodeRef hold : this.holdService.getHolds(filePlan)) {
                    LOGGER.debug("Analyzing hold {}", (Object)hold.getId());
                    BatchWorker batchWorker = new BatchWorker(hold);
                    LOGGER.debug("Hold has {} items to be analyzed", (Object)batchWorker.getWorkSize());
                    while (batchWorker.hasMoreResults()) {
                        this.processBatch(hold, batchWorker);
                    }
                    LOGGER.debug("Patched {} items in hold", (Object)batchWorker.getTotalPatchedNodes());
                    patchedNodesCounter += batchWorker.getTotalPatchedNodes();
                }
            }
            LOGGER.debug("Patch applied to {} children across all holds", (Object)patchedNodesCounter);
        }
        finally {
            this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
    }

    private void processBatch(NodeRef hold, BatchWorker batch) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Collection<ChildAssociationRef> childRefs = batch.getNextWork();
            LOGGER.debug("Processing batch of {} children in hold", (Object)childRefs.size());
            for (ChildAssociationRef child : childRefs) {
                NodeRef childNodeRef = child.getChildRef();
                if (this.isChildContainedByHold(hold, childNodeRef)) continue;
                this.nodeService.addChild(hold, childNodeRef, ContentModel.ASSOC_CONTAINS, PATCH_ASSOC_NAME);
                batch.countPatchedNode();
            }
            return null;
        }, false, true);
    }

    private boolean isChildContainedByHold(NodeRef hold, NodeRef child) {
        List parentAssocs = this.nodeService.getParentAssocs(child, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        return parentAssocs.stream().anyMatch(entry -> entry.getParentRef().equals((Object)hold) && entry.getTypeQName().equals((Object)ContentModel.ASSOC_CONTAINS));
    }

    private class BatchWorker {
        NodeRef hold;
        int totalPatchedNodes = 0;
        int workSize;
        Iterator<ChildAssociationRef> iterator;

        public BatchWorker(NodeRef hold) {
            this.hold = hold;
            this.setupHold();
        }

        public boolean hasMoreResults() {
            return this.iterator == null ? true : this.iterator.hasNext();
        }

        public void countPatchedNode() {
            ++this.totalPatchedNodes;
        }

        public int getTotalPatchedNodes() {
            return this.totalPatchedNodes;
        }

        public int getWorkSize() {
            return this.workSize;
        }

        public void setupHold() {
            List holdChildren = RMv35HoldNewChildAssocPatch.this.nodeService.getChildAssocs(this.hold, (QNamePattern)RecordsManagementModel.ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL, Integer.MAX_VALUE, false);
            this.iterator = holdChildren.listIterator();
            this.workSize = holdChildren.size();
        }

        public Collection<ChildAssociationRef> getNextWork() {
            ArrayList<ChildAssociationRef> frozenNodes = new ArrayList<ChildAssociationRef>(RMv35HoldNewChildAssocPatch.this.batchSize);
            while (this.iterator.hasNext() && frozenNodes.size() < RMv35HoldNewChildAssocPatch.this.batchSize) {
                frozenNodes.add(this.iterator.next());
            }
            return frozenNodes;
        }
    }
}

