/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;

public class RMMethodSecurityPostProcessor
implements BeanFactoryPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMMethodSecurityPostProcessor.class);
    public static final String PROP_OBJECT_DEFINITION_SOURCE = "objectDefinitionSource";
    public static final String PROPERTY_PREFIX = "rm.methodsecurity.";
    public static final String SECURITY_BEAN_POSTFIX = "_security";
    private Set<String> securityBeanNames;
    private Set<String> securityBeanNameCache;
    private Properties properties;

    public void setSecurityBeanNames(Set<String> securityBeanNames) {
        this.securityBeanNames = securityBeanNames;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String bean : this.getSecurityBeanNames(beanFactory)) {
            if (!beanFactory.containsBeanDefinition(bean)) continue;
            LOGGER.debug("Adding RM method security definitions for {}", (Object)bean);
            BeanDefinition beanDef = beanFactory.getBeanDefinition(bean);
            PropertyValue beanValue = beanDef.getPropertyValues().getPropertyValue(PROP_OBJECT_DEFINITION_SOURCE);
            if (beanValue == null) continue;
            String beanStringValue = ((TypedStringValue)beanValue.getValue()).getValue();
            String mergedStringValue = this.merge(beanStringValue);
            beanDef.getPropertyValues().addPropertyValue(PROP_OBJECT_DEFINITION_SOURCE, (Object)new TypedStringValue(mergedStringValue));
        }
    }

    private Set<String> getSecurityBeanNames(ConfigurableListableBeanFactory beanFactory) {
        if (this.securityBeanNameCache == null) {
            this.securityBeanNameCache = new HashSet<String>(21);
            if (this.securityBeanNames != null) {
                this.securityBeanNameCache.addAll(this.securityBeanNames);
            }
            for (Object key : this.properties.keySet()) {
                int index;
                String[] split = ((String)key).split("\\.");
                String securityBeanName = split[index = split.length - 2] + SECURITY_BEAN_POSTFIX;
                if (this.securityBeanNameCache.contains(securityBeanName) || !beanFactory.containsBean(securityBeanName)) continue;
                LOGGER.debug("Adding {} to list from properties.", (Object)securityBeanName);
                this.securityBeanNameCache.add(securityBeanName);
            }
        }
        return this.securityBeanNameCache;
    }

    private String merge(String beanStringValue) {
        Map<String, String> map = this.convertToMap(beanStringValue);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String propKey = PROPERTY_PREFIX + key;
            if (this.properties.containsKey(propKey)) {
                map.put(key, entry.getValue() + "," + this.properties.getProperty(propKey));
                continue;
            }
            LOGGER.warn("Missing RM security definition for method {}", (Object)key);
        }
        return this.convertToString(map);
    }

    protected Map<String, String> convertToMap(String stringValue) {
        String[] values = stringValue.trim().split("\n");
        HashMap<String, String> map = new HashMap<String, String>(values.length);
        for (String value : values) {
            String trimmed = value.trim();
            if (trimmed.isEmpty()) continue;
            String[] pair = trimmed.split("=", 2);
            if (pair.length != 2) {
                throw new AlfrescoRuntimeException("Could not convert string to map " + trimmed);
            }
            map.put(pair[0], pair[1]);
        }
        return map;
    }

    private String convertToString(Map<String, String> map) {
        StringBuilder buffer = new StringBuilder(256);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return buffer.toString();
    }
}

