/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.dataset.DataSet;
import org.alfresco.module.org_alfresco_module_rm.dataset.DataSetService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DataSetsGet
extends DeclarativeWebScript {
    private static final String ARG_SITE_NAME = "site";
    private static final String ARG_UNLOADED_ONLY = "unloadedonly";
    private DataSetService dataSetService;
    private SiteService siteService;

    public void setDataSetService(DataSetService dataSetService) {
        this.dataSetService = dataSetService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String siteName = req.getParameter(ARG_SITE_NAME);
        if (StringUtils.isBlank((CharSequence)siteName)) {
            siteName = "rm";
        }
        NodeRef filePlan = this.siteService.getContainer(siteName, "documentLibrary");
        String unloadedOnlyParam = req.getParameter(ARG_UNLOADED_ONLY);
        boolean unloadedOnly = false;
        if (StringUtils.isNotBlank((CharSequence)unloadedOnlyParam)) {
            unloadedOnly = Boolean.valueOf(unloadedOnlyParam);
        }
        Map<String, DataSet> dataSets = this.dataSetService.getDataSets(filePlan, unloadedOnly);
        ArrayList dataSetList = new ArrayList(dataSets.size());
        for (Map.Entry<String, DataSet> entry : dataSets.entrySet()) {
            HashMap<String, String> dataSet = new HashMap<String, String>(3);
            DataSet value = entry.getValue();
            String dataSetId = value.getId();
            String isLoaded = String.valueOf(this.dataSetService.isLoadedDataSet(filePlan, dataSetId));
            dataSet.put("label", value.getLabel());
            dataSet.put("id", dataSetId);
            dataSet.put("isLoaded", isLoaded);
            dataSetList.add(dataSet);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("datasets", dataSetList);
        return model;
    }
}

