/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.util.ArrayList;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.alfresco.util.GUID;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RMCaveatConfigScriptTest
extends BaseRMWebScriptTestCase {
    protected static final String RM_LIST = "rmc:smListTest";
    protected static final String RM_LIST_URI_ELEM = "rmc_smListTest";
    private static final String URL_RM_CONSTRAINTS = "/api/rma/admin/rmconstraints";

    public void testGetRMConstraints() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RM_CONSTRAINTS), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        System.out.println(response.getContentAsString());
        RMCaveatConfigScriptTest.assertNotNull((Object)top.getJSONArray("data"));
        this.caveatConfigService.addRMConstraint(RM_LIST, "my title", new String[0]);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RM_CONSTRAINTS), 200);
        top = new JSONObject(response.getContentAsString());
        System.out.println(response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        boolean found = false;
        RMCaveatConfigScriptTest.assertTrue((String)"no data returned", (data.length() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < data.length(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            String name = obj.getString("constraintName");
            RMCaveatConfigScriptTest.assertNotNull((String)"constraintName is null", (Object)name);
            String url = obj.getString("url");
            RMCaveatConfigScriptTest.assertNotNull((String)"detail url is null", (Object)name);
            if (name.equalsIgnoreCase(RM_LIST)) {
                found = true;
            }
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        }
    }

    public void testGetRMConstraint() throws Exception {
        if (this.caveatConfigService.getRMConstraint(RM_LIST) != null) {
            this.caveatConfigService.deleteRMConstraint(RM_LIST);
        }
        this.caveatConfigService.addRMConstraint(RM_LIST, "my title", new String[0]);
        this.createUser("fbloggs");
        this.createUser("jrogers");
        this.createUser("jdoe");
        ArrayList<String> values = new ArrayList<String>();
        values.add("NOFORN");
        values.add("FGI");
        this.caveatConfigService.updateRMConstraintListAuthority(RM_LIST, "fbloggs", values);
        this.caveatConfigService.updateRMConstraintListAuthority(RM_LIST, "jrogers", values);
        this.caveatConfigService.updateRMConstraintListAuthority(RM_LIST, "jdoe", values);
        String url = "/api/rma/admin/rmconstraints/rmc_smListTest";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        System.out.println(response.getContentAsString());
        String constraintName = data.getString("constraintName");
        RMCaveatConfigScriptTest.assertNotNull((String)"constraintName is null", (Object)constraintName);
        url = "/api/rma/admin/rmconstraints/rmc_wibble";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 404);
        this.deleteUser("fbloggs");
        this.deleteUser("jrogers");
        this.deleteUser("jdoe");
    }

    public void testUpdateRMConstraint() throws Exception {
        String constraintName = null;
        String title = "test Update RM Constraint title";
        JSONArray array = new JSONArray();
        array.put((Object)"LEMON");
        array.put((Object)"BANANA");
        array.put((Object)"PEACH");
        JSONObject obj = new JSONObject();
        obj.put("allowedValues", (Object)array);
        obj.put("constraintTitle", (Object)title);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RM_CONSTRAINTS, obj.toString(), "application/json"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        constraintName = data.getString("constraintName");
        JSONArray allowedValues = data.getJSONArray("allowedValues");
        RMCaveatConfigScriptTest.assertTrue((String)"values not correct", (boolean)this.compare(array, allowedValues));
        String newTitle = "this is the new title";
        array = new JSONArray();
        array.put((Object)"LEMON");
        array.put((Object)"APPLE");
        obj = new JSONObject();
        obj.put("allowedValues", (Object)array);
        obj.put("constraintName", (Object)constraintName);
        obj.put("constraintTitle", (Object)newTitle);
        System.out.println(obj.toString());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/rma/admin/rmconstraints/" + constraintName, obj.toString(), "application/json"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONObject("data");
        System.out.println(response.getContentAsString());
        String url = data.getString("url");
        String constraintName2 = data.getString("constraintName");
        String constraintTitle = data.getString("constraintTitle");
        JSONArray allowedValues2 = data.getJSONArray("allowedValues");
        RMCaveatConfigScriptTest.assertTrue((allowedValues2.length() == 2 ? 1 : 0) != 0);
        RMCaveatConfigScriptTest.assertTrue((String)"values not correct", (boolean)this.compare(array, allowedValues2));
        RMCaveatConfigScriptTest.assertNotNull((Object)url);
        RMCaveatConfigScriptTest.assertEquals((String)constraintName2, (String)constraintName);
        RMCaveatConfigScriptTest.assertNotNull((Object)constraintTitle);
        RMCaveatConfigScriptTest.assertEquals((String)"title not as expected", (String)constraintTitle, (String)newTitle);
        TestWebScriptServer.Response resp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject top2 = new JSONObject(resp2.getContentAsString());
        System.out.println("Problem here");
        System.out.println(resp2.getContentAsString());
        JSONObject data2 = top2.getJSONObject("data");
        String constraintTitle2 = data2.getString("constraintTitle");
        JSONArray allowedValues22 = data2.getJSONArray("allowedValues");
        RMCaveatConfigScriptTest.assertTrue((String)"values not correct", (boolean)this.compare(array, allowedValues22));
        RMCaveatConfigScriptTest.assertTrue((String)"allowedValues is not 2", (allowedValues22.length() == 2 ? 1 : 0) != 0);
        RMCaveatConfigScriptTest.assertEquals((String)constraintName2, (String)constraintName);
        RMCaveatConfigScriptTest.assertNotNull((Object)constraintTitle2);
        RMCaveatConfigScriptTest.assertEquals((String)"title not as expected", (String)constraintTitle2, (String)newTitle);
        newTitle = "update with no values";
        JSONObject obj2 = new JSONObject();
        obj2.put("constraintName", (Object)RM_LIST);
        obj2.put("constraintTitle", (Object)newTitle);
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/rma/admin/rmconstraints/" + constraintName, obj2.toString(), "application/json"), 200);
        JSONObject top3 = new JSONObject(response2.getContentAsString());
        JSONObject data3 = top3.getJSONObject("data");
        System.out.println(response2.getContentAsString());
        String url2 = data3.getString("url");
        String constraintName22 = data3.getString("constraintName");
        String constraintTitle3 = data3.getString("constraintTitle");
        JSONArray allowedValues3 = data3.getJSONArray("allowedValues");
        RMCaveatConfigScriptTest.assertTrue((allowedValues3.length() == 2 ? 1 : 0) != 0);
        RMCaveatConfigScriptTest.assertNotNull((Object)url2);
        RMCaveatConfigScriptTest.assertEquals((String)constraintName22, (String)constraintName);
        RMCaveatConfigScriptTest.assertNotNull((Object)constraintTitle3);
        RMCaveatConfigScriptTest.assertEquals((String)"title not as expected", (String)constraintTitle3, (String)newTitle);
        JSONArray array2 = new JSONArray();
        array2.put((Object)"LEMON");
        array2.put((Object)"APPLE");
        obj2 = new JSONObject();
        obj2.put("allowedValues", (Object)array2);
        System.out.println(obj2.toString());
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/rma/admin/rmconstraints/" + constraintName, obj2.toString(), "application/json"), 200);
        top3 = new JSONObject(response2.getContentAsString());
        data3 = top3.getJSONObject("data");
        System.out.println(response2.getContentAsString());
        array2 = new JSONArray();
        array2.put((Object)"PEAR");
        array2.put((Object)"LEMON");
        array2.put((Object)"APPLE");
        obj2 = new JSONObject();
        obj2.put("allowedValues", (Object)array2);
        System.out.println(obj2.toString());
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/rma/admin/rmconstraints/" + constraintName, obj2.toString(), "application/json"), 200);
        top3 = new JSONObject(response2.getContentAsString());
        data3 = top3.getJSONObject("data");
        System.out.println(response2.getContentAsString());
        array2 = new JSONArray();
        array2.put((Object)"APPLE");
        array2.put((Object)"LEMON");
        obj2 = new JSONObject();
        obj2.put("allowedValues", (Object)array2);
        System.out.println(obj2.toString());
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/rma/admin/rmconstraints/" + constraintName, obj2.toString(), "application/json"), 200);
        top3 = new JSONObject(response2.getContentAsString());
        data3 = top3.getJSONObject("data");
        System.out.println(response2.getContentAsString());
    }

    public void testCreateRMConstraint() throws Exception {
        JSONArray array = new JSONArray();
        array.put((Object)"NOFORN");
        array.put((Object)"FGI");
        JSONObject obj = new JSONObject();
        obj.put("allowedValues", (Object)array);
        obj.put("constraintName", (Object)RM_LIST);
        obj.put("constraintTitle", (Object)GUID.generate());
        System.out.println(obj.toString());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RM_CONSTRAINTS, obj.toString(), "application/json"), 200);
        String url = "/api/rma/admin/rmconstraints/rmc_smListTest";
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject top = new JSONObject(response2.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        System.out.println(response2.getContentAsString());
        String constraintName = data.getString("constraintName");
        RMCaveatConfigScriptTest.assertNotNull((String)"constraintName is null", (Object)constraintName);
        String title = GUID.generate();
        JSONArray array2 = new JSONArray();
        array2.put((Object)"Red");
        array2.put((Object)"Blue");
        array2.put((Object)"Green");
        JSONObject obj2 = new JSONObject();
        obj2.put("allowedValues", (Object)array2);
        obj2.put("constraintTitle", (Object)title);
        System.out.println(obj2.toString());
        TestWebScriptServer.Response response3 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RM_CONSTRAINTS, obj2.toString(), "application/json"), 200);
        JSONObject top2 = new JSONObject(response3.getContentAsString());
        JSONObject data2 = top2.getJSONObject("data");
        System.out.println(response3.getContentAsString());
        String url2 = data2.getString("url");
        String constraintName2 = data2.getString("constraintName");
        String constraintTitle = data2.getString("constraintTitle");
        JSONArray allowedValues = data2.getJSONArray("allowedValues");
        RMCaveatConfigScriptTest.assertTrue((allowedValues.length() == 3 ? 1 : 0) != 0);
        RMCaveatConfigScriptTest.assertNotNull((Object)url2);
        RMCaveatConfigScriptTest.assertNotNull((Object)constraintName2);
        RMCaveatConfigScriptTest.assertNotNull((Object)constraintTitle);
        RMCaveatConfigScriptTest.assertEquals((String)"title not as expected", (String)constraintTitle, (String)title);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url2), 200);
        array = new JSONArray();
        obj = new JSONObject();
        obj.put("allowedValues", (Object)array);
        obj.put("constraintName", (Object)"rmc_whazoo");
        obj.put("constraintTitle", (Object)GUID.generate());
        System.out.println(obj.toString());
        TestWebScriptServer.Response response4 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RM_CONSTRAINTS, obj.toString(), "application/json"), 200);
        JSONObject top3 = new JSONObject(response4.getContentAsString());
        JSONObject data3 = top3.getJSONObject("data");
        System.out.println(response4.getContentAsString());
    }

    public void testGetRMConstraintValues() throws Exception {
        this.createUser("fbloggs");
        this.createUser("jrogers");
        this.createUser("jdoe");
        if (this.caveatConfigService.getRMConstraint(RM_LIST) != null) {
            this.caveatConfigService.deleteRMConstraint(RM_LIST);
        }
        this.caveatConfigService.addRMConstraint(RM_LIST, "my title", new String[0]);
        ArrayList<String> values = new ArrayList<String>();
        values.add("NOFORN");
        values.add("FGI");
        this.caveatConfigService.updateRMConstraintListAuthority(RM_LIST, "fbloggs", values);
        this.caveatConfigService.updateRMConstraintListAuthority(RM_LIST, "jrogers", values);
        this.caveatConfigService.updateRMConstraintListAuthority(RM_LIST, "jdoe", values);
        String url = "/api/rma/admin/rmconstraints/rmc_smListTest/values";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        System.out.println(response.getContentAsString());
        String constraintName = data.getString("constraintName");
        RMCaveatConfigScriptTest.assertNotNull((String)"constraintName is null", (Object)constraintName);
        String constraintTitle = data.getString("constraintTitle");
        RMCaveatConfigScriptTest.assertNotNull((String)"constraintTitle is null", (Object)constraintTitle);
        JSONArray values2 = data.getJSONArray("values");
        RMCaveatConfigScriptTest.assertTrue((String)"details array does not contain 2 elements", (values2.length() == 2 ? 1 : 0) != 0);
        boolean fgiFound = false;
        boolean nofornFound = false;
        for (int i = 0; i < values2.length(); ++i) {
            JSONObject value = values2.getJSONObject(i);
            if (value.getString("valueName").equalsIgnoreCase("FGI")) {
                fgiFound = true;
            }
            if (!value.getString("valueName").equalsIgnoreCase("NOFORN")) continue;
            nofornFound = true;
        }
        RMCaveatConfigScriptTest.assertTrue((String)"fgi not found", (boolean)fgiFound);
        RMCaveatConfigScriptTest.assertTrue((String)"noforn not found", (boolean)nofornFound);
        this.deleteUser("fbloggs");
        this.deleteUser("jrogers");
        this.deleteUser("jdoe");
    }

    public void testUpdateRMConstraintValue() throws Exception {
        int i;
        if (this.caveatConfigService.getRMConstraint(RM_LIST) != null) {
            this.caveatConfigService.deleteRMConstraint(RM_LIST);
        }
        this.caveatConfigService.addRMConstraint(RM_LIST, "my title", new String[0]);
        JSONArray values = new JSONArray();
        JSONArray authorities = new JSONArray();
        authorities.put((Object)"fbloggs");
        authorities.put((Object)"jdoe");
        JSONObject valueA = new JSONObject();
        valueA.put("value", (Object)"NOFORN");
        valueA.put("authorities", (Object)authorities);
        values.put((Object)valueA);
        JSONObject valueB = new JSONObject();
        valueB.put("value", (Object)"FGI");
        valueB.put("authorities", (Object)authorities);
        values.put((Object)valueB);
        JSONObject obj = new JSONObject();
        obj.put("values", (Object)values);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rma/admin/rmconstraints/rmc:smListTest/values", obj.toString(), "application/json"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        System.out.println(response.getContentAsString());
        RMCaveatConfigScriptTest.assertNotNull((String)"data is null", (Object)data);
        JSONArray myValues = data.getJSONArray("values");
        RMCaveatConfigScriptTest.assertTrue((String)"two values not found", (myValues.length() == 2 ? 1 : 0) != 0);
        for (int i2 = 0; i2 < myValues.length(); ++i2) {
            JSONObject jSONObject = myValues.getJSONObject(i2);
        }
        values = new JSONArray();
        authorities = new JSONArray();
        authorities.put((Object)"fbloggs");
        authorities.put((Object)"jrogers");
        valueA = new JSONObject();
        valueA.put("value", (Object)"NOCON");
        valueA.put("authorities", (Object)authorities);
        values.put((Object)valueA);
        JSONObject obj2 = new JSONObject();
        obj2.put("values", (Object)values);
        System.out.println(obj2.toString());
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rma/admin/rmconstraints/rmc:smListTest/values", obj2.toString(), "application/json"), 200);
        JSONObject top2 = new JSONObject(response2.getContentAsString());
        JSONObject data2 = top2.getJSONObject("data");
        System.out.println(response2.getContentAsString());
        RMCaveatConfigScriptTest.assertNotNull((String)"data is null", (Object)data2);
        JSONArray myValues2 = data2.getJSONArray("values");
        RMCaveatConfigScriptTest.assertTrue((String)"three values not found", (myValues2.length() == 3 ? 1 : 0) != 0);
        for (i = 0; i < myValues2.length(); ++i) {
            JSONObject i2 = myValues2.getJSONObject(i);
        }
        values = new JSONArray();
        authorities = new JSONArray();
        authorities.put((Object)"fbloggs");
        authorities.put((Object)"jrogers");
        authorities.put((Object)"jdoe");
        valueA = new JSONObject();
        valueA.put("value", (Object)"NOFORN");
        valueA.put("authorities", (Object)authorities);
        values.put((Object)valueA);
        obj2 = new JSONObject();
        obj2.put("values", (Object)values);
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rma/admin/rmconstraints/rmc:smListTest/values", obj2.toString(), "application/json"), 200);
        top2 = new JSONObject(response2.getContentAsString());
        data2 = top2.getJSONObject("data");
        System.out.println(response2.getContentAsString());
        RMCaveatConfigScriptTest.assertNotNull((String)"data is null", (Object)data2);
        myValues2 = data2.getJSONArray("values");
        RMCaveatConfigScriptTest.assertTrue((String)"three values not found", (myValues2.length() == 3 ? 1 : 0) != 0);
        for (i = 0; i < myValues2.length(); ++i) {
            JSONObject i2 = myValues2.getJSONObject(i);
        }
        values = new JSONArray();
        authorities = new JSONArray();
        authorities.put((Object)"jrogers");
        valueA = new JSONObject();
        valueA.put("value", (Object)"NOCON");
        valueA.put("authorities", (Object)authorities);
        values.put((Object)valueA);
        obj2 = new JSONObject();
        obj2.put("values", (Object)values);
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rma/admin/rmconstraints/rmc:smListTest/values", obj2.toString(), "application/json"), 200);
        top2 = new JSONObject(response2.getContentAsString());
        data2 = top2.getJSONObject("data");
        System.out.println(response2.getContentAsString());
        RMCaveatConfigScriptTest.assertNotNull((String)"data is null", (Object)data2);
        myValues2 = data2.getJSONArray("values");
        RMCaveatConfigScriptTest.assertTrue((String)"three values not found", (myValues2.length() == 3 ? 1 : 0) != 0);
        boolean foundNOCON = false;
        boolean foundNOFORN = false;
        boolean foundFGI = false;
        for (int i3 = 0; i3 < myValues2.length(); ++i3) {
            JSONObject myObj = myValues2.getJSONObject(i3);
            if (myObj.getString("valueName").equalsIgnoreCase("NOCON")) {
                foundNOCON = true;
            }
            if (myObj.getString("valueName").equalsIgnoreCase("NOFORN")) {
                foundNOFORN = true;
            }
            if (!myObj.getString("valueName").equalsIgnoreCase("FGI")) continue;
            foundFGI = true;
        }
        RMCaveatConfigScriptTest.assertTrue((String)"not found NOCON", (boolean)foundNOCON);
        RMCaveatConfigScriptTest.assertTrue((String)"not found NOFORN", (boolean)foundNOFORN);
        RMCaveatConfigScriptTest.assertTrue((String)"not found FGI", (boolean)foundFGI);
    }

    public void testDeleteRMConstraint() throws Exception {
        if (this.caveatConfigService.getRMConstraint(RM_LIST) != null) {
            this.caveatConfigService.deleteRMConstraint(RM_LIST);
        }
        this.caveatConfigService.addRMConstraint(RM_LIST, "my title", new String[0]);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rma/admin/rmconstraints/rmc:smListTest"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rma/admin/rmconstraints/rmc_wibble"), 404);
    }

    private boolean compare(JSONArray from, JSONArray to) throws Exception {
        int i;
        ArrayList<String> ret = new ArrayList<String>();
        if (from.length() != to.length()) {
            RMCaveatConfigScriptTest.fail((String)("arrays are different lengths" + from.length() + ", " + to.length()));
            return false;
        }
        for (i = 0; i < to.length(); ++i) {
            ret.add(to.getString(i));
        }
        for (i = 0; i < from.length(); ++i) {
            String val = from.getString(i);
            if (ret.contains(val)) continue;
            RMCaveatConfigScriptTest.fail((String)("Value not contained in list:" + val));
            return false;
        }
        return true;
    }

    public void testGetRMConstraintValue() throws Exception {
        String constraintName = null;
        String title = "Get Constraint Value";
        JSONArray array = new JSONArray();
        array.put((Object)"POTATO");
        array.put((Object)"CARROT");
        array.put((Object)"TURNIP");
        JSONObject obj = new JSONObject();
        obj.put("allowedValues", (Object)array);
        obj.put("constraintTitle", (Object)title);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RM_CONSTRAINTS, obj.toString(), "application/json"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        constraintName = data.getString("constraintName");
        JSONArray allowedValues = data.getJSONArray("allowedValues");
        RMCaveatConfigScriptTest.assertTrue((String)"values not correct", (boolean)this.compare(array, allowedValues));
        String url = "/api/rma/admin/rmconstraints/" + constraintName + "/values/CARROT";
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject jSONObject = new JSONObject(response2.getContentAsString());
        url = "/api/rma/admin/rmconstraints/" + constraintName + "/values/ONION";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 404);
    }
}

