/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.GUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RoleRestApiTest
extends BaseRMWebScriptTestCase
implements RecordsManagementModel {
    protected static final String GET_ROLES_URL_BY_SITE = "/api/rma/admin/{0}/rmroles";
    protected static final String GET_ROLES_URL_BY_FILEPLAN = "/api/rma/admin/{0}/{1}/{2}/rmroles";
    protected static final String SERVICE_URL_PREFIX = "/alfresco/service";
    protected static final String APPLICATION_JSON = "application/json";

    private String getRolesUrlBySite() {
        return MessageFormat.format(GET_ROLES_URL_BY_SITE, this.siteId);
    }

    private String getRoleUrlByFilePlan() {
        return MessageFormat.format(GET_ROLES_URL_BY_FILEPLAN, this.filePlan.getStoreRef().getProtocol(), this.filePlan.getStoreRef().getIdentifier(), this.filePlan.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRoles() throws Exception {
        String role1 = GUID.generate();
        String role2 = GUID.generate();
        String role3 = GUID.generate();
        this.filePlanRoleService.createRole(this.filePlan, role1, "My Test Role", this.getListOfCapabilities(5));
        this.filePlanRoleService.createRole(this.filePlan, role2, "My Test Role Too", this.getListOfCapabilities(5));
        this.filePlanRoleService.createRole(this.filePlan, role3, "System Administrator", this.getListOfCapabilities(5));
        String groupName = GUID.generate();
        String group = this.authorityService.createAuthority(AuthorityType.GROUP, groupName, "monkey", null);
        this.filePlanRoleService.assignRoleToAuthority(this.filePlan, role1, "admin");
        this.filePlanRoleService.assignRoleToAuthority(this.filePlan, role1, group);
        try {
            TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getRolesUrlBySite()), 200);
            String rspContent = rsp.getContentAsString();
            JSONObject obj = new JSONObject(rspContent);
            JSONObject roles = obj.getJSONObject("data");
            RoleRestApiTest.assertNotNull((Object)roles);
            JSONObject roleObj = roles.getJSONObject(role1);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role1, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            roleObj = roles.getJSONObject(role2);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role2, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role Too", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            roleObj = roles.getJSONObject(role3);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role3, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"System Administrator", (Object)roleObj.get("displayLabel"));
            rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getRoleUrlByFilePlan()), 200);
            rspContent = rsp.getContentAsString();
            obj = new JSONObject(rspContent);
            roles = obj.getJSONObject("data");
            RoleRestApiTest.assertNotNull((Object)roles);
            roleObj = roles.getJSONObject(role1);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role1, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            roleObj = roles.getJSONObject(role2);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role2, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role Too", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getRolesUrlBySite() + "?user=admin"), 200);
            rspContent = rsp.getContentAsString();
            obj = new JSONObject(rspContent);
            roles = obj.getJSONObject("data");
            RoleRestApiTest.assertNotNull((Object)roles);
            roleObj = roles.getJSONObject(role1);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role1, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            RoleRestApiTest.assertFalse((boolean)roles.has(role2));
            rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getRoleUrlByFilePlan() + "?auths=true"), 200);
            rspContent = rsp.getContentAsString();
            System.out.println(rspContent);
            obj = new JSONObject(rspContent);
            roles = obj.getJSONObject("data");
            RoleRestApiTest.assertNotNull((Object)roles);
            roleObj = roles.getJSONObject(role1);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role1, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            JSONArray users = roleObj.getJSONArray("assignedUsers");
            RoleRestApiTest.assertNotNull((Object)users);
            RoleRestApiTest.assertEquals((int)1, (int)users.length());
            JSONArray groups = roleObj.getJSONArray("assignedGroups");
            RoleRestApiTest.assertNotNull((Object)groups);
            RoleRestApiTest.assertEquals((int)1, (int)groups.length());
            roleObj = roles.getJSONObject(role2);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role2, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role Too", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            users = roleObj.getJSONArray("assignedUsers");
            RoleRestApiTest.assertNotNull((Object)users);
            RoleRestApiTest.assertEquals((int)0, (int)users.length());
            groups = roleObj.getJSONArray("assignedGroups");
            RoleRestApiTest.assertNotNull((Object)groups);
            RoleRestApiTest.assertEquals((int)0, (int)groups.length());
        }
        finally {
            this.filePlanRoleService.deleteRole(this.filePlan, role1);
            this.filePlanRoleService.deleteRole(this.filePlan, role2);
        }
    }

    private void checkCapabilities(JSONObject role, int expectedCount) throws JSONException {
        JSONObject capabilities = role.getJSONObject("capabilities");
        RoleRestApiTest.assertNotNull((Object)capabilities);
        int count = 0;
        Iterator it = capabilities.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            RoleRestApiTest.assertNotNull((Object)key);
            RoleRestApiTest.assertNotNull((Object)capabilities.getString(key));
            ++count;
        }
        RoleRestApiTest.assertEquals((int)expectedCount, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPostRoles() throws Exception {
        Set<Capability> caps = this.getListOfCapabilities(5);
        JSONArray arrCaps = new JSONArray();
        for (Capability cap : caps) {
            arrCaps.put((Object)cap.getName());
        }
        String roleName = GUID.generate();
        JSONObject obj = new JSONObject();
        obj.put("name", (Object)roleName);
        obj.put("displayLabel", (Object)"Display Label");
        obj.put("capabilities", (Object)arrCaps);
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.getRolesUrlBySite(), obj.toString(), APPLICATION_JSON), 200);
        try {
            String rspContent = rsp.getContentAsString();
            JSONObject resultObj = new JSONObject(rspContent);
            JSONObject roleObj = resultObj.getJSONObject("data");
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)roleName, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"Display Label", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
        }
        finally {
            this.filePlanRoleService.deleteRole(this.filePlan, roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutRole() throws Exception {
        String role1 = GUID.generate();
        this.filePlanRoleService.createRole(this.filePlan, role1, "My Test Role", this.getListOfCapabilities(5));
        try {
            Set<Capability> caps = this.getListOfCapabilities(4, 8);
            JSONArray arrCaps = new JSONArray();
            for (Capability cap : caps) {
                System.out.println(cap.getName());
                arrCaps.put((Object)cap.getName());
            }
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)role1);
            obj.put("displayLabel", (Object)"Changed");
            obj.put("capabilities", (Object)arrCaps);
            TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getRolesUrlBySite() + "/" + role1, obj.toString(), APPLICATION_JSON), 200);
            String rspContent = rsp.getContentAsString();
            JSONObject result = new JSONObject(rspContent);
            JSONObject roleObj = result.getJSONObject("data");
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role1, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"Changed", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 4);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getRolesUrlBySite() + "/cheese", obj.toString(), APPLICATION_JSON), 404);
        }
        finally {
            this.filePlanRoleService.deleteRole(this.filePlan, role1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRole() throws Exception {
        String role1 = GUID.generate();
        this.filePlanRoleService.createRole(this.filePlan, role1, "My Test Role", this.getListOfCapabilities(5));
        try {
            TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getRolesUrlBySite() + "/" + role1), 200);
            String rspContent = rsp.getContentAsString();
            JSONObject obj = new JSONObject(rspContent);
            JSONObject roleObj = obj.getJSONObject("data");
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertNotNull((Object)roleObj);
            RoleRestApiTest.assertEquals((Object)role1, (Object)roleObj.get("name"));
            RoleRestApiTest.assertEquals((Object)"My Test Role", (Object)roleObj.get("displayLabel"));
            this.checkCapabilities(roleObj, 5);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getRolesUrlBySite() + "/cheese"), 404);
        }
        finally {
            this.filePlanRoleService.deleteRole(this.filePlan, role1);
        }
    }

    public void testDeleteRole() throws Exception {
        String role1 = GUID.generate();
        RoleRestApiTest.assertFalse((boolean)this.filePlanRoleService.existsRole(this.filePlan, role1));
        this.filePlanRoleService.createRole(this.filePlan, role1, "My Test Role", this.getListOfCapabilities(5));
        RoleRestApiTest.assertTrue((boolean)this.filePlanRoleService.existsRole(this.filePlan, role1));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(this.getRolesUrlBySite() + "/" + role1), 200);
        RoleRestApiTest.assertFalse((boolean)this.filePlanRoleService.existsRole(this.filePlan, role1));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(this.getRolesUrlBySite() + "/cheese"), 404);
    }

    private Set<Capability> getListOfCapabilities(int size) {
        return this.getListOfCapabilities(size, 0);
    }

    private Set<Capability> getListOfCapabilities(int size, int offset) {
        HashSet<Capability> result = new HashSet<Capability>(size);
        Set caps = this.capabilityService.getCapabilities(false);
        int count = 0;
        for (Capability cap : caps) {
            if (count >= size + offset) break;
            if (count >= offset) {
                result.add(cap);
            }
            ++count;
        }
        return result;
    }
}

