/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.job;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.job.RecordsManagementJobExecuter;
import org.alfresco.module.org_alfresco_module_rm.job.publish.PublishExecutor;
import org.alfresco.module.org_alfresco_module_rm.job.publish.PublishExecutorRegistry;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishUpdatesJobExecuter
extends RecordsManagementJobExecuter {
    private static Log logger = LogFactory.getLog(PublishUpdatesJobExecuter.class);
    private NodeService nodeService;
    private SearchService searchService;
    private PublishExecutorRegistry publishExecutorRegistry;
    private DictionaryService dictionaryService;
    private BehaviourFilter behaviourFilter;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPublishExecutorRegistry(PublishExecutorRegistry publishExecutorRegistry) {
        this.publishExecutorRegistry = publishExecutorRegistry;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public void executeImpl() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Job Starting");
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() {
                if (PublishUpdatesJobExecuter.this.rmLoaded()) {
                    List<NodeRef> nodeRefs = PublishUpdatesJobExecuter.this.getUpdatedNodes();
                    for (NodeRef nodeRef : nodeRefs) {
                        boolean publishing;
                        if (!PublishUpdatesJobExecuter.this.nodeService.exists(nodeRef) || (publishing = ((Boolean)PublishUpdatesJobExecuter.this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_PUBLISH_IN_PROGRESS)).booleanValue())) continue;
                        PublishUpdatesJobExecuter.this.markPublishInProgress(nodeRef);
                        try {
                            Date start = new Date();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Starting publish of updates ...");
                                logger.debug((Object)("   - for " + nodeRef.toString()));
                                logger.debug((Object)("   - at " + start.toString()));
                            }
                            PublishUpdatesJobExecuter.this.publishUpdates(nodeRef);
                            if (!logger.isDebugEnabled()) continue;
                            Date end = new Date();
                            long duration = end.getTime() - start.getTime();
                            logger.debug((Object)"Completed publish of updates ...");
                            logger.debug((Object)("   - for " + nodeRef.toString()));
                            logger.debug((Object)("   - at " + end.toString()));
                            logger.debug((Object)("   - duration " + Long.toString(duration)));
                        }
                        finally {
                            PublishUpdatesJobExecuter.this.unmarkPublishInProgress(nodeRef);
                        }
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Job Finished");
        }
    }

    private boolean rmLoaded() {
        boolean result = false;
        if (this.dictionaryService != null && this.dictionaryService.getAspect(ASPECT_UNPUBLISHED_UPDATE) != null) {
            result = true;
        }
        return result;
    }

    private List<NodeRef> getUpdatedNodes() {
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>> execution = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<NodeRef> execute() {
                StringBuilder sb = new StringBuilder();
                sb.append("ASPECT:\"rma:").append(RecordsManagementModel.ASPECT_UNPUBLISHED_UPDATE.getLocalName()).append("\"");
                String query = sb.toString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing query " + query));
                }
                List resultNodes = null;
                SearchParameters searchParameters = new SearchParameters();
                searchParameters.setQuery(query);
                searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                searchParameters.setLanguage("fts-alfresco");
                try (ResultSet results = PublishUpdatesJobExecuter.this.searchService.query(searchParameters);){
                    resultNodes = results.getNodeRefs();
                }
                catch (AlfrescoRuntimeException exception) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Error executing query, " + exception.getMessage()));
                    }
                    throw exception;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found " + resultNodes.size() + " disposition action definitions updates awaiting publishing."));
                }
                return resultNodes;
            }
        };
        return (List)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)execution, true);
    }

    private void markPublishInProgress(final NodeRef nodeRef) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> execution = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Marking updated node as publish in progress. (node=" + nodeRef.toString() + ")"));
                }
                PublishUpdatesJobExecuter.this.behaviourFilter.disableBehaviour(nodeRef, RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
                try {
                    if (PublishUpdatesJobExecuter.this.nodeService.exists(nodeRef)) {
                        PublishUpdatesJobExecuter.this.nodeService.setProperty(nodeRef, RecordsManagementModel.PROP_PUBLISH_IN_PROGRESS, (Serializable)Boolean.valueOf(true));
                    }
                }
                finally {
                    PublishUpdatesJobExecuter.this.behaviourFilter.enableBehaviour(nodeRef, RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)execution);
    }

    private void publishUpdates(final NodeRef nodeRef) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> execution = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                PublishUpdatesJobExecuter.this.behaviourFilter.disableBehaviour(nodeRef, RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
                try {
                    String updateTo = (String)((Object)PublishUpdatesJobExecuter.this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_UPDATE_TO));
                    if (updateTo != null) {
                        PublishExecutor executor;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Node update to " + updateTo + " (noderef=" + nodeRef.toString() + ")"));
                        }
                        if ((executor = PublishUpdatesJobExecuter.this.publishExecutorRegistry.get(updateTo)) == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Unable to find a corresponding publish executor. (noderef=" + nodeRef.toString() + ", updateTo=" + updateTo + ")"));
                            }
                            throw new AlfrescoRuntimeException("Unable to find a corresponding publish executor. (noderef=" + nodeRef.toString() + ", updateTo=" + updateTo + ")");
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Attempting to publish updates. (nodeRef=" + nodeRef.toString() + ")"));
                        }
                        executor.publish(nodeRef);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Unable to publish, because publish executor is not set.");
                    }
                    PublishUpdatesJobExecuter.this.nodeService.removeAspect(nodeRef, RecordsManagementModel.ASPECT_UNPUBLISHED_UPDATE);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Publish updates complete. (nodeRef=" + nodeRef.toString() + ")"));
                    }
                }
                finally {
                    PublishUpdatesJobExecuter.this.behaviourFilter.enableBehaviour(nodeRef, RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)execution);
    }

    private void unmarkPublishInProgress(final NodeRef nodeRef) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> execution = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                PublishUpdatesJobExecuter.this.behaviourFilter.disableBehaviour(nodeRef, RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
                try {
                    if (PublishUpdatesJobExecuter.this.nodeService.exists(nodeRef) && PublishUpdatesJobExecuter.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_UNPUBLISHED_UPDATE)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Removing publish in progress marker from updated node, because update was not successful. (node=" + nodeRef.toString() + ")"));
                        }
                        PublishUpdatesJobExecuter.this.nodeService.setProperty(nodeRef, RecordsManagementModel.PROP_PUBLISH_IN_PROGRESS, (Serializable)Boolean.valueOf(false));
                    }
                }
                finally {
                    PublishUpdatesJobExecuter.this.behaviourFilter.enableBehaviour(nodeRef, RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)execution);
    }
}

