/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.admin.CustomMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.PropertyAlreadyExistsMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.script.BaseCustomPropertyWebScript;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomPropertyDefinitionPut
extends BaseCustomPropertyWebScript {
    private RecordsManagementAdminService rmAdminService;
    private static final String PARAM_LABEL = "label";
    private static final String PARAM_CONSTRAINT_REF = "constraintRef";
    private static final String PROP_ID = "propId";
    private static final String URL = "url";
    private static final String MESSAGE = "errorMessage";

    public void setRecordsManagementAdminService(RecordsManagementAdminService rmAdminService) {
        this.rmAdminService = rmAdminService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        JSONObject json = null;
        Map<String, Object> ftlModel = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            try {
                ftlModel = this.handlePropertyDefinitionUpdate(req, json);
            }
            catch (CustomMetadataException e) {
                status.setCode(400);
                ftlModel = new HashMap<String, Object>();
                ftlModel.put(MESSAGE, e.getMessage());
            }
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return ftlModel;
    }

    protected Map<String, Object> handlePropertyDefinitionUpdate(WebScriptRequest req, JSONObject json) throws JSONException, CustomMetadataException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Serializable> params = this.getParamsFromUrlAndJson(req, json);
        QName propertyQName = this.updatePropertyDefinition(params);
        String localName = propertyQName.getLocalName();
        result.put(PROP_ID, localName);
        String urlResult = req.getServicePath();
        result.put(URL, urlResult);
        return result;
    }

    protected QName updatePropertyDefinition(Map<String, Serializable> params) throws CustomMetadataException {
        QName result;
        block10: {
            result = null;
            boolean updated = false;
            String propId = (String)((Object)params.get(PROP_ID));
            ParameterCheck.mandatoryString((String)PROP_ID, (String)propId);
            QName propQName = this.rmAdminService.getQNameForClientId(propId);
            if (propQName == null) {
                propQName = this.rmAdminService.getQNameForClientId(URLEncoder.encode((String)propId));
            }
            if (propQName == null) {
                throw new WebScriptException(404, "Could not find property definition for: " + propId);
            }
            if (params.containsKey(PARAM_CONSTRAINT_REF)) {
                String constraintRef = (String)((Object)params.get(PARAM_CONSTRAINT_REF));
                List constraints = this.rmAdminService.getCustomPropertyDefinitions().get(propQName).getConstraints();
                if (constraintRef == null) {
                    result = this.rmAdminService.removeCustomPropertyDefinitionConstraints(propQName);
                    updated = !constraints.isEmpty();
                } else {
                    boolean exists = false;
                    for (ConstraintDefinition constraintDefinition : constraints) {
                        if (!constraintDefinition.getConstraint().getShortName().equalsIgnoreCase(constraintRef)) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        QName constraintRefQName = QName.createQName((String)constraintRef, (NamespacePrefixResolver)this.getNamespaceService());
                        result = this.rmAdminService.setCustomPropertyDefinitionConstraint(propQName, constraintRefQName);
                        updated = true;
                    }
                }
            }
            if (params.containsKey(PARAM_LABEL)) {
                String label = (String)((Object)params.get(PARAM_LABEL));
                try {
                    result = this.rmAdminService.updateCustomPropertyDefinitionName(propQName, label);
                }
                catch (PropertyAlreadyExistsMetadataException ex) {
                    if (updated) break block10;
                    String propIdAsString = this.rmAdminService.getQNameForClientId(label).toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
                    throw new PropertyAlreadyExistsMetadataException(propIdAsString);
                }
            }
        }
        return result;
    }

    protected Map<String, Serializable> getParamsFromUrlAndJson(WebScriptRequest req, JSONObject json) throws JSONException {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String propId = (String)templateVars.get(PROP_ID);
        if (propId != null) {
            params.put(PROP_ID, (Serializable)((Object)propId));
        }
        Iterator iter = json.keys();
        while (iter.hasNext()) {
            String nextKeyString = (String)iter.next();
            String nextValueString = null;
            if (!json.isNull(nextKeyString)) {
                nextValueString = json.getString(nextKeyString);
            }
            params.put(nextKeyString, (Serializable)((Object)nextValueString));
        }
        return params;
    }
}

