/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.script.DispositionAbstractBase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DispositionLifecycleGet
extends DispositionAbstractBase {
    PersonService personService;

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String completedBy;
        String startedBy;
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        DispositionAction nextAction = this.getDispositionService().getNextDispositionAction(nodeRef);
        if (nextAction == null) {
            HashMap<String, Object> nextActionModel = new HashMap<String, Object>(2);
            nextActionModel.put("notFound", true);
            nextActionModel.put("message", "Node " + nodeRef.toString() + " does not have a disposition lifecycle");
            HashMap<String, Object> model = new HashMap<String, Object>(1);
            model.put("nextaction", nextActionModel);
            return model;
        }
        HashMap<String, Object> nextActionModel = new HashMap<String, Object>(8);
        String serviceUrl = req.getServiceContextPath() + req.getPathInfo();
        nextActionModel.put("url", serviceUrl);
        nextActionModel.put("name", nextAction.getName());
        nextActionModel.put("label", nextAction.getLabel());
        nextActionModel.put("eventsEligible", this.getDispositionService().isNextDispositionActionEligible(nodeRef));
        if (nextAction.getAsOfDate() != null) {
            nextActionModel.put("asOf", ISO8601DateFormat.format((Date)nextAction.getAsOfDate()));
        }
        if (nextAction.getStartedAt() != null) {
            nextActionModel.put("startedAt", ISO8601DateFormat.format((Date)nextAction.getStartedAt()));
        }
        if ((startedBy = nextAction.getStartedBy()) != null) {
            nextActionModel.put("startedBy", startedBy);
            this.addUsersRealName(nextActionModel, startedBy, "startedBy");
        }
        if (nextAction.getCompletedAt() != null) {
            nextActionModel.put("completedAt", ISO8601DateFormat.format((Date)nextAction.getCompletedAt()));
        }
        if ((completedBy = nextAction.getCompletedBy()) != null) {
            nextActionModel.put("completedBy", completedBy);
            this.addUsersRealName(nextActionModel, completedBy, "completedBy");
        }
        ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>();
        for (EventCompletionDetails event : nextAction.getEventCompletionDetails()) {
            events.add(this.createEventModel(event));
        }
        nextActionModel.put("events", events);
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("nextaction", nextActionModel);
        return model;
    }

    protected Map<String, Object> createEventModel(EventCompletionDetails event) {
        HashMap<String, Object> model = new HashMap<String, Object>(8);
        model.put("name", event.getEventName());
        model.put("label", event.getEventLabel());
        model.put("automatic", event.isEventExecutionAutomatic());
        model.put("complete", event.isEventComplete());
        String completedBy = event.getEventCompletedBy();
        if (completedBy != null) {
            model.put("completedBy", completedBy);
            this.addUsersRealName(model, completedBy, "completedBy");
        }
        if (event.getEventCompletedAt() != null) {
            model.put("completedAt", ISO8601DateFormat.format((Date)event.getEventCompletedAt()));
        }
        return model;
    }

    protected void addUsersRealName(Map<String, Object> model, String userName, String propertyPrefix) {
        NodeRef user = this.personService.getPerson(userName);
        if (user != null) {
            String lastName;
            String firstName = (String)((Object)this.getNodeService().getProperty(user, ContentModel.PROP_FIRSTNAME));
            if (firstName != null) {
                model.put(propertyPrefix + "FirstName", firstName);
            }
            if ((lastName = (String)((Object)this.getNodeService().getProperty(user, ContentModel.PROP_LASTNAME))) != null) {
                model.put(propertyPrefix + "LastName", lastName);
            }
        }
    }
}

