/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.recordfolders;

import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.impl.SearchTypesFactory;
import org.alfresco.rm.rest.api.model.Record;
import org.alfresco.rm.rest.api.model.RecordFolder;
import org.alfresco.rm.rest.api.model.UploadInfo;
import org.alfresco.rm.rest.api.recordfolders.RecordFolderEntityResource;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.extensions.webscripts.servlet.FormData;

@RelationshipResource(name="records", entityResource=RecordFolderEntityResource.class, title="Children of a record folder")
public class RecordFolderChildrenRelation
implements RelationshipResourceAction.Read<Record>,
RelationshipResourceAction.Create<Record>,
MultiPartRelationshipResourceAction.Create<Record> {
    private FilePlanComponentsApiUtils apiUtils;
    private SearchTypesFactory searchTypesFactory;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setSearchTypesFactory(SearchTypesFactory searchTypesFactory) {
        this.searchTypesFactory = searchTypesFactory;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @WebApiDescription(title="Return a paged list of records for the record folder identified by 'recordFolderId'")
    public CollectionWithPagingInfo<Record> readAll(String recordFolderId, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordFolderId", recordFolderId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(recordFolderId, RecordsManagementModel.TYPE_RECORD_FOLDER);
        Set<QName> searchTypeQNames = this.searchTypesFactory.buildSearchTypesForUnfiledEndpoint(parameters, null);
        PagingResults pagingResults = this.fileFolderService.list(parentNodeRef, null, searchTypeQNames, null, this.apiUtils.getSortProperties(parameters), null, Util.getPagingRequest((Paging)parameters.getPaging()));
        final List page = pagingResults.getPage();
        final HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        AbstractList<Record> nodes = new AbstractList<Record>(){

            @Override
            public Record get(int index) {
                FileInfo info = (FileInfo)page.get(index);
                return RecordFolderChildrenRelation.this.nodesModelFactory.createRecord(info, parameters, mapUserInfo, true);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        RecordFolder sourceEntity = null;
        if (parameters.includeSource()) {
            FileInfo info = this.fileFolderService.getFileInfo(parentNodeRef);
            sourceEntity = this.nodesModelFactory.createRecordFolder(info, parameters, mapUserInfo, true);
        }
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)nodes, (boolean)pagingResults.hasMoreItems(), (Integer)((Integer)pagingResults.getTotalResultCount().getFirst()), sourceEntity);
    }

    @WebApiDescription(title="Create one (or more) records as children of a record folder identified by 'recordFolderId'")
    public List<Record> create(String recordFolderId, final List<Record> nodeInfos, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordFolderId", recordFolderId);
        ParameterCheck.mandatory((String)"nodeInfos", nodeInfos);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(recordFolderId, RecordsManagementModel.TYPE_RECORD_FOLDER);
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() {
                LinkedList<NodeRef> createdNodes = new LinkedList<NodeRef>();
                for (Record nodeInfo : nodeInfos) {
                    NodeRef newNodeRef = RecordFolderChildrenRelation.this.apiUtils.createRMNode(parentNodeRef, nodeInfo, parameters);
                    createdNodes.add(newNodeRef);
                }
                return createdNodes;
            }
        };
        List createdNodes = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        LinkedList<Record> result = new LinkedList<Record>();
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        for (NodeRef newNodeRef : createdNodes) {
            FileInfo info = this.fileFolderService.getFileInfo(newNodeRef);
            this.apiUtils.postActivity(info, parentNodeRef, "org.alfresco.documentlibrary.file-added");
            result.add(this.nodesModelFactory.createRecord(info, parameters, mapUserInfo, false));
        }
        return result;
    }

    @WebApiDescription(title="Upload file content and meta-data into the repository.")
    @WebApiParam(name="formData", title="A single form data", description="A single form data which holds FormFields.")
    public Record create(String recordFolderId, FormData formData, final Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("recordFolderId", recordFolderId);
        ParameterCheck.mandatory((String)"formData", (Object)formData);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final UploadInfo uploadInfo = new UploadInfo(formData);
        final NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(recordFolderId, RecordsManagementModel.TYPE_RECORD_FOLDER, uploadInfo.getRelativePath());
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() {
                return RecordFolderChildrenRelation.this.apiUtils.uploadRecord(parentNodeRef, uploadInfo, parameters);
            }
        };
        NodeRef newNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        FileInfo info = this.fileFolderService.getFileInfo(newNode);
        this.apiUtils.postActivity(info, parentNodeRef, "org.alfresco.documentlibrary.file-added");
        return this.nodesModelFactory.createRecord(info, parameters, null, false);
    }
}

