/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.jscript.app.evaluator;

import java.util.Collections;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.jscript.app.evaluator.FrozenEvaluator;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class FrozenEvaluatorUnitTest
extends BaseUnitTest {
    @Mock(name="kinds")
    Set<FilePlanComponentKind> mockedKinds;
    @Spy
    @InjectMocks
    FrozenEvaluator evaluator;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ((Set)Mockito.doReturn((Object)false).when(this.mockedKinds)).contains(FilePlanComponentKind.RECORD_CATEGORY);
        ((Set)Mockito.doReturn((Object)true).when(this.mockedKinds)).contains(FilePlanComponentKind.RECORD_FOLDER);
        ((Set)Mockito.doReturn((Object)true).when(this.mockedKinds)).contains(FilePlanComponentKind.RECORD);
    }

    @Test
    public void isNotRecordOrRecordFolder() {
        NodeRef nodeRef = this.generateNodeRef(TYPE_RECORD_CATEGORY);
        ((FilePlanService)Mockito.doReturn((Object)FilePlanComponentKind.RECORD_CATEGORY).when((Object)this.mockedFilePlanService)).getFilePlanComponentKind(nodeRef);
        boolean result = this.evaluator.evaluate(this.filePlanComponent);
        Assert.assertFalse((boolean)result);
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.never())).heldBy(this.filePlanComponent, true);
    }

    @Test
    public void isNotHeld() {
        ((FilePlanService)Mockito.doReturn((Object)FilePlanComponentKind.RECORD).when((Object)this.mockedFilePlanService)).getFilePlanComponentKind(this.record);
        ((HoldService)Mockito.doReturn((Object)Collections.EMPTY_LIST).when((Object)this.mockedHoldService)).heldBy(this.record, true);
        boolean result = this.evaluator.evaluate(this.record);
        Assert.assertFalse((boolean)result);
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).heldBy(this.record, true);
    }

    @Test
    public void isHeldByAtLeastOne() {
        ((FilePlanService)Mockito.doReturn((Object)FilePlanComponentKind.RECORD).when((Object)this.mockedFilePlanService)).getFilePlanComponentKind(this.record);
        ((HoldService)Mockito.doReturn(Collections.singletonList(this.generateNodeRef(TYPE_HOLD))).when((Object)this.mockedHoldService)).heldBy(this.record, true);
        boolean result = this.evaluator.evaluate(this.record);
        Assert.assertTrue((boolean)result);
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).heldBy(this.record, true);
    }
}

