/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.jscript.app.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.jscript.app.evaluator.TransferEvaluator;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class TransferEvaluatorUnitTest
extends BaseUnitTest {
    private NodeRef transfer;
    @Spy
    @InjectMocks
    TransferEvaluator transferEvaluator;

    @Override
    public void before() throws Exception {
        super.before();
        this.transfer = this.generateNodeRef(TYPE_TRANSFER);
    }

    private List<ChildAssociationRef> getParentAssocs(NodeRef provided) {
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>(1);
        result.add(new ChildAssociationRef(ASSOC_TRANSFERRED, this.transfer, AlfMock.generateQName(), provided, false, 1));
        return result;
    }

    @Test
    public void isNotTransferringRecord() {
        ((NodeService)Mockito.doReturn(Collections.emptyList()).when((Object)this.mockedNodeService)).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        Assert.assertFalse((boolean)this.transferEvaluator.evaluate(this.record));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((RecordFolderService)Mockito.verify((Object)this.mockedRecordFolderService, (VerificationMode)Mockito.times((int)1))).getRecordFolders(this.record);
    }

    @Test
    public void isTransferringWhenExpectingAccending() {
        ((NodeService)Mockito.doReturn((Object)Boolean.FALSE).when((Object)this.mockedNodeService)).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((NodeService)Mockito.doReturn(this.getParentAssocs(this.record)).when((Object)this.mockedNodeService)).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        this.transferEvaluator.setTransferAccessionIndicator(true);
        Assert.assertFalse((boolean)this.transferEvaluator.evaluate(this.record));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((RecordFolderService)Mockito.verify((Object)this.mockedRecordFolderService, (VerificationMode)Mockito.never())).getRecordFolders(this.record);
    }

    @Test
    public void transferringRecord() {
        ((NodeService)Mockito.doReturn((Object)Boolean.FALSE).when((Object)this.mockedNodeService)).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((NodeService)Mockito.doReturn(this.getParentAssocs(this.record)).when((Object)this.mockedNodeService)).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        Assert.assertTrue((boolean)this.transferEvaluator.evaluate(this.record));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((RecordFolderService)Mockito.verify((Object)this.mockedRecordFolderService, (VerificationMode)Mockito.never())).getRecordFolders(this.record);
    }

    @Test
    public void transferringRecordFolder() {
        ((NodeService)Mockito.doReturn((Object)Boolean.FALSE).when((Object)this.mockedNodeService)).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((NodeService)Mockito.doReturn(this.getParentAssocs(this.recordFolder)).when((Object)this.mockedNodeService)).getParentAssocs(this.recordFolder, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        Assert.assertTrue((boolean)this.transferEvaluator.evaluate(this.recordFolder));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getParentAssocs(this.recordFolder, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((RecordFolderService)Mockito.verify((Object)this.mockedRecordFolderService, (VerificationMode)Mockito.never())).getRecordFolders(this.record);
    }

    @Test
    public void transferringRecordWithinRecordFolder() {
        ((NodeService)Mockito.doReturn((Object)Boolean.FALSE).when((Object)this.mockedNodeService)).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((NodeService)Mockito.doReturn(Collections.emptyList()).when((Object)this.mockedNodeService)).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ((NodeService)Mockito.doReturn(this.getParentAssocs(this.recordFolder)).when((Object)this.mockedNodeService)).getParentAssocs(this.recordFolder, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        Assert.assertTrue((boolean)this.transferEvaluator.evaluate(this.record));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((RecordFolderService)Mockito.verify((Object)this.mockedRecordFolderService, (VerificationMode)Mockito.times((int)1))).getRecordFolders(this.record);
    }

    @Test
    public void accendingRecord() {
        ((NodeService)Mockito.doReturn((Object)Boolean.TRUE).when((Object)this.mockedNodeService)).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((NodeService)Mockito.doReturn(this.getParentAssocs(this.record)).when((Object)this.mockedNodeService)).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        this.transferEvaluator.setTransferAccessionIndicator(true);
        Assert.assertTrue((boolean)this.transferEvaluator.evaluate(this.record));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getParentAssocs(this.record, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(this.transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
        ((RecordFolderService)Mockito.verify((Object)this.mockedRecordFolderService, (VerificationMode)Mockito.never())).getRecordFolders(this.record);
    }
}

