/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.module.org_alfresco_module_rm.model.rma.type.RecordCategoryType;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.MockAuthenticationUtilHelper;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RecordCategoryTypeUnitTest
extends BaseUnitTest {
    @Mock
    private AuthenticationUtil mockAuthenticationUtil;
    @Mock
    private VitalRecordService mockedVitalRecordService;
    @InjectMocks
    private RecordCategoryType recordCategoryType;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        MockAuthenticationUtilHelper.setup(this.mockAuthenticationUtil);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateNonAceptedTypes() throws Exception {
        NodeRef recordCategoryNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_CATEGORY);
        QName type = AlfMock.generateQName();
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordCategoryNodeRef, nodeRef);
        this.recordCategoryType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test
    public void testCreateRecordCategory() throws Exception {
        NodeRef recordCategoryNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_CATEGORY);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_CATEGORY, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordCategoryNodeRef, nodeRef);
        this.recordCategoryType.onCreateChildAssociation(childAssocRef, true);
    }

    @Test
    public void testCreateRecordFolder() throws Exception {
        NodeRef recordCategoryNodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_CATEGORY);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_RECORD_FOLDER, true);
        ChildAssociationRef childAssocRef = this.generateChildAssociationRef(recordCategoryNodeRef, nodeRef);
        this.recordCategoryType.onCreateChildAssociation(childAssocRef, true);
    }
}

