/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.action;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class ExecuteScriptActionTest
extends BaseRMTestCase {
    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testExecuteScript() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String fileOriginalName = (String)((Object)this.nodeService.getProperty(this.dmDocument, ContentModel.PROP_NAME));
        final NodeRef validScriptRef = this.addTempScript("valid-rm-script.js", "document.properties.name = \"Valid_\" + document.properties.name;\ndocument.save();");
        final NodeRef invalidScriptRef = this.addTempScript("invalid-rm-script.js", "document.properties.name = \"Invalid_\" + document.properties.name;\ndocument.save();", this.dmFolder);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Script outside proper Data Dictionary folder should not be executed", IllegalStateException.class){

            public void run() throws Exception {
                ExecuteScriptActionTest.this.executeAction(invalidScriptRef, ExecuteScriptActionTest.this.dmDocument);
            }
        }, this.dmCollaborator);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                ExecuteScriptActionTest.this.executeAction(validScriptRef, ExecuteScriptActionTest.this.dmDocument);
                return null;
            }

            public void test(Void result) throws Exception {
                String currentName = (String)((Object)ExecuteScriptActionTest.this.nodeService.getProperty(ExecuteScriptActionTest.this.dmDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)currentName, (String)("Valid_" + fileOriginalName));
            }
        }, this.dmCollaborator);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ExecuteScriptActionTest.this.nodeService.setProperty(ExecuteScriptActionTest.this.dmDocument, ContentModel.PROP_NAME, (Serializable)((Object)fileOriginalName));
                return null;
            }
        });
    }

    private NodeRef addTempScript(final String scriptFileName, final String javaScript, final NodeRef parentRef) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        return (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef script = ExecuteScriptActionTest.this.nodeService.getChildByName(parentRef, ContentModel.ASSOC_CONTAINS, scriptFileName);
                if (script == null) {
                    script = ExecuteScriptActionTest.this.nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)scriptFileName), ContentModel.TYPE_CONTENT).getChildRef();
                    ExecuteScriptActionTest.this.nodeService.setProperty(script, ContentModel.PROP_NAME, (Serializable)((Object)scriptFileName));
                    ContentWriter contentWriter = ExecuteScriptActionTest.this.contentService.getWriter(script, ContentModel.PROP_CONTENT, true);
                    contentWriter.setMimetype("application/x-javascript");
                    contentWriter.setEncoding("UTF-8");
                    contentWriter.putContent(javaScript);
                }
                return script;
            }
        });
    }

    private NodeRef addTempScript(final String scriptFileName, final String javaScript) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        return (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef companyHomeRef = ExecuteScriptActionTest.this.repositoryHelper.getCompanyHome();
                NodeRef dataDictionaryRef = ExecuteScriptActionTest.this.nodeService.getChildByName(companyHomeRef, ContentModel.ASSOC_CONTAINS, "Data Dictionary");
                NodeRef rmFolder = ExecuteScriptActionTest.this.nodeService.getChildByName(dataDictionaryRef, ContentModel.ASSOC_CONTAINS, "Records Management");
                NodeRef scriptsRef = ExecuteScriptActionTest.this.nodeService.getChildByName(rmFolder, ContentModel.ASSOC_CONTAINS, "Records Management Scripts");
                return ExecuteScriptActionTest.this.addTempScript(scriptFileName, javaScript, scriptsRef);
            }
        });
    }

    private void executeAction(NodeRef scriptRef, NodeRef nodeRef) {
        Action action = this.actionService.createAction("rmscript");
        action.setParameterValue("script-ref", (Serializable)scriptRef);
        this.actionService.executeAction(action, nodeRef);
    }
}

