/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.test.util.CommonRMTestUtils;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteRole;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.GUID;

public class DataLoadSystemTest {
    protected FilePlanService filePlanService;
    protected RecordFolderService recordFolderService;
    protected RecordService recordService;
    protected TransactionService transactionService;
    protected AuthorityService authorityService;
    protected MutableAuthenticationService authenticationService;
    protected PersonService personService;
    protected FilePlanRoleService filePlanRoleService;
    protected SiteService siteService;
    protected FileFolderService fileFolderService;
    private static final int BATCH_SIZE = 100;
    private static final int ROOT_CATEGORY_COUNT = 0;
    private static final int RECORD_FOLDER_COUNT = 0;
    private static final int RECORD_COUNT = 0;
    private static final int RM_GROUP_COUNT = 0;
    private static final int RM_USER_COUNT = 0;
    private static final int USER_COUNT = 0;
    private static final int INPLACE_RECORD_COUNT = 5000;
    private ApplicationContext applicationContext;
    CommonRMTestUtils utils;
    private int totalCount;
    private List<NodeRef> recordCategories;
    private List<NodeRef> recordFolders;
    private List<String> groups;

    protected String[] getConfigLocations() {
        return new String[]{"classpath:alfresco/application-context.xml", "classpath:test-context.xml"};
    }

    @Before
    public void before() {
        this.applicationContext = ApplicationContextHelper.getApplicationContext((String[])this.getConfigLocations());
        this.utils = new CommonRMTestUtils(this.applicationContext);
        this.filePlanService = (FilePlanService)this.applicationContext.getBean("FilePlanService");
        this.recordFolderService = (RecordFolderService)this.applicationContext.getBean("RecordFolderService");
        this.recordService = (RecordService)this.applicationContext.getBean("RecordService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.authorityService = (AuthorityService)this.applicationContext.getBean("authorityService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.filePlanRoleService = (FilePlanRoleService)this.applicationContext.getBean("filePlanRoleService");
        this.siteService = (SiteService)this.applicationContext.getBean("siteService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
    }

    @Test
    public void loadAllData() {
        this.loadFilePlanData();
        this.loadRMUsersAndGroups();
        this.loadInPlace();
    }

    private void loadInPlace() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                final SiteInfo site = DataLoadSystemTest.this.siteService.getSite("test");
                if (site == null) {
                    throw new AlfrescoRuntimeException("The collab site test is not present.");
                }
                final NodeRef filePlan = DataLoadSystemTest.this.filePlanService.getFilePlanBySiteId("rm");
                if (filePlan == null) {
                    Assert.fail((String)"The default RM site is not present.");
                }
                DataLoadSystemTest.this.repeatInTransactionBatches(new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        String userName = GUID.generate();
                        System.out.println("Creating user " + userName);
                        DataLoadSystemTest.this.createPerson(userName, true);
                        DataLoadSystemTest.this.siteService.setMembership("test", userName, SiteRole.SiteCollaborator.toString());
                        return null;
                    }
                }, 0);
                DataLoadSystemTest.this.repeatInTransactionBatches(new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        NodeRef docLib = DataLoadSystemTest.this.siteService.getContainer(site.getShortName(), "documentLibrary");
                        NodeRef document = DataLoadSystemTest.this.fileFolderService.create(docLib, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                        DataLoadSystemTest.this.recordService.createRecord(filePlan, document);
                        return null;
                    }
                }, 5000);
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    private void loadRMUsersAndGroups() {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                final NodeRef filePlan = DataLoadSystemTest.this.filePlanService.getFilePlanBySiteId("rm");
                if (filePlan == null) {
                    Assert.fail((String)"The default RM site is not present.");
                }
                DataLoadSystemTest.this.groups = new ArrayList<String>();
                DataLoadSystemTest.this.repeatInTransactionBatches(new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        String groupName = GUID.generate();
                        System.out.println("Creating group " + groupName);
                        DataLoadSystemTest.this.groups.add("GROUP_" + DataLoadSystemTest.this.authorityService.createAuthority(AuthorityType.GROUP, groupName));
                        DataLoadSystemTest.this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", groupName);
                        return null;
                    }
                }, 0);
                for (final String group : DataLoadSystemTest.this.groups) {
                    DataLoadSystemTest.this.repeatInTransactionBatches(new AuthenticationUtil.RunAsWork<Void>(){

                        public Void doWork() throws Exception {
                            String userName = GUID.generate();
                            System.out.println("Creating user " + userName + " and adding to group " + group);
                            DataLoadSystemTest.this.createPerson(userName, true);
                            DataLoadSystemTest.this.authorityService.addAuthority(group, userName);
                            return null;
                        }
                    }, 0);
                }
                return null;
            }
        });
    }

    private void loadFilePlanData() {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                final NodeRef filePlan = DataLoadSystemTest.this.filePlanService.getFilePlanBySiteId("rm");
                if (filePlan == null) {
                    Assert.fail((String)"The default RM site is not present.");
                }
                DataLoadSystemTest.this.recordCategories = new ArrayList<NodeRef>(0);
                DataLoadSystemTest.this.repeatInTransactionBatches(new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        DataLoadSystemTest.this.recordCategories.add(DataLoadSystemTest.this.filePlanService.createRecordCategory(filePlan, GUID.generate()));
                        return null;
                    }
                }, 0);
                DataLoadSystemTest.this.recordFolders = new ArrayList<NodeRef>(0);
                for (final NodeRef recordCategory : DataLoadSystemTest.this.recordCategories) {
                    DataLoadSystemTest.this.repeatInTransactionBatches(new AuthenticationUtil.RunAsWork<Void>(){

                        public Void doWork() throws Exception {
                            DataLoadSystemTest.this.recordFolders.add(DataLoadSystemTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate()));
                            return null;
                        }
                    }, 0);
                }
                for (final NodeRef recordFolder : DataLoadSystemTest.this.recordFolders) {
                    DataLoadSystemTest.this.repeatInTransactionBatches(new AuthenticationUtil.RunAsWork<Void>(){

                        public Void doWork() throws Exception {
                            DataLoadSystemTest.this.recordService.createRecordFromContent(recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
                            return null;
                        }
                    }, 0);
                }
                return null;
            }
        });
    }

    private NodeRef createPerson(String userName, boolean createAuth) {
        if (createAuth) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName);
        return this.personService.createPerson(properties);
    }

    private void repeatInTransactionBatches(final AuthenticationUtil.RunAsWork<Void> work, final int count) throws Exception {
        this.totalCount = 0;
        while (this.totalCount < count) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    int batchSize = count - DataLoadSystemTest.this.totalCount;
                    if (batchSize >= 100) {
                        batchSize = 100;
                    }
                    for (int i = 0; i < batchSize; ++i) {
                        work.doWork();
                        ++DataLoadSystemTest.this.totalCount;
                    }
                    System.out.println("Created " + DataLoadSystemTest.this.totalCount + " of " + count);
                    return null;
                }
            }, false, true);
        }
    }
}

