/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.NodeTypeUtility;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.module.org_alfresco_module_rm.util.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;

public class ServiceBaseImplUnitTest {
    @InjectMocks
    private ServiceBaseImpl serviceBase;
    @Mock(name="nodeService")
    private NodeService mockedNodeService;
    @Mock(name="transactionalResourceHelper")
    private TransactionalResourceHelper mockedTransactionalResourceHelper;
    @Mock(name="applicationContext")
    protected ApplicationContext mockedApplicationContext;
    @Mock(name="nodeTypeUtility")
    protected NodeTypeUtility mockedNodeTypeUtility;
    @Mock
    private Map<Object, Object> mockedCache;

    @Before
    public void before() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((ApplicationContext)Mockito.doReturn((Object)this.mockedNodeService).when((Object)this.mockedApplicationContext)).getBean("dbNodeService");
    }

    @Test
    public void getFilePlan() {
        NodeRef nodeRef = new NodeRef("test://node/");
        Mockito.when((Object)this.mockedNodeService.getType(nodeRef)).thenReturn((Object)ContentModel.TYPE_CONTENT);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(ContentModel.TYPE_CONTENT, RecordsManagementModel.TYPE_FILE_PLAN)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedTransactionalResourceHelper.getMap((Object)"rm.servicebase.getFilePlan")).thenReturn(this.mockedCache);
        Mockito.when((Object)this.mockedCache.containsKey(nodeRef)).thenReturn((Object)false);
        this.serviceBase.getFilePlan(nodeRef);
        ((Map)Mockito.verify(this.mockedCache, (VerificationMode)Mockito.never())).put(nodeRef, null);
    }
}

