/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.vital;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.vital.ReviewedAction;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.extensions.webscripts.GUID;

public class ReviewedActionUnitTest
implements RecordsManagementModel {
    @Mock
    private VitalRecordService mockedVitalRecordService;
    @Mock
    private RecordService mockedRecordService;
    @Mock
    private NodeService mockedNodeService;
    @InjectMocks
    private ReviewedAction reviewedAction;

    @Before
    public void testSetup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testReviewRecordWithAdHocReviewPeriod() {
        NodeRef mockedRecord = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
        Mockito.when((Object)this.mockedRecordService.isRecord(mockedRecord)).thenReturn((Object)true);
        VitalRecordDefinition mockedVRDef = (VitalRecordDefinition)Mockito.mock(VitalRecordDefinition.class);
        Mockito.when((Object)mockedVRDef.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedVitalRecordService.getVitalRecordDefinition(mockedRecord)).thenReturn((Object)mockedVRDef);
        Period mockedReviewPeriod = (Period)Mockito.mock(Period.class);
        Mockito.when((Object)mockedReviewPeriod.getPeriodType()).thenReturn((Object)"immediately");
        Mockito.when((Object)mockedVRDef.getReviewPeriod()).thenReturn((Object)mockedReviewPeriod);
        this.reviewedAction.executeImpl(null, mockedRecord);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).removeProperty(mockedRecord, PROP_REVIEW_AS_OF);
    }

    @Test
    public void testReviewRecordWithRecurentReviewPeriod() {
        NodeRef mockedRecord = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
        Mockito.when((Object)this.mockedRecordService.isRecord(mockedRecord)).thenReturn((Object)true);
        VitalRecordDefinition mockedVRDef = (VitalRecordDefinition)Mockito.mock(VitalRecordDefinition.class);
        Mockito.when((Object)mockedVRDef.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedVitalRecordService.getVitalRecordDefinition(mockedRecord)).thenReturn((Object)mockedVRDef);
        Date mockedNextReviewDate = (Date)Mockito.mock(Date.class);
        Mockito.when((Object)mockedVRDef.getNextReviewDate()).thenReturn((Object)mockedNextReviewDate);
        Period mockedReviewPeriod = (Period)Mockito.mock(Period.class);
        Mockito.when((Object)mockedReviewPeriod.getPeriodType()).thenReturn((Object)"day");
        Mockito.when((Object)mockedVRDef.getReviewPeriod()).thenReturn((Object)mockedReviewPeriod);
        this.reviewedAction.executeImpl(null, mockedRecord);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setProperty(mockedRecord, PROP_REVIEW_AS_OF, (Serializable)mockedNextReviewDate);
    }
}

