/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.roles;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseWebScriptUnitTest;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.content.ContentStreamer;
import org.alfresco.repo.web.scripts.roles.DynamicAuthoritiesGet;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class DynamicAuthoritiesGetUnitTest
extends BaseWebScriptUnitTest
implements RecordsManagementModel {
    private static final Long ASPECT_ID = 123L;
    private static final QName ASPECT = AlfMock.generateQName();
    @Mock
    private PatchDAO mockedPatchDAO;
    @Mock
    private NodeDAO mockedNodeDAO;
    @Mock
    private QNameDAO mockedQnameDAO;
    @Mock
    private NodeService mockedNodeService;
    @Mock
    private PermissionService mockedPermissionService;
    @Mock
    private ExtendedSecurityService mockedExtendedSecurityService;
    @Mock
    private TransactionService mockedTransactionService;
    @Mock
    private RetryingTransactionHelper mockedRetryingTransactionHelper;
    @Mock
    private ContentStreamer contentStreamer;
    @Mock
    private FileFolderService mockedFileFolderService;
    @InjectMocks
    private DynamicAuthoritiesGet webScript;

    @Override
    protected AbstractWebScript getWebScript() {
        return this.webScript;
    }

    @Override
    protected String getWebScriptTemplate() {
        return "alfresco/templates/webscripts/org/alfresco/repository/roles/rm-dynamicauthorities.get.json.ftl";
    }

    @Override
    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.webScript.setNodeService(this.mockedNodeService);
        this.webScript.setPermissionService(this.mockedPermissionService);
        this.webScript.setExtendedSecurityService(this.mockedExtendedSecurityService);
        this.webScript.setFileFolderService(this.mockedFileFolderService);
        Answer<Object> doInTransactionAnswer = new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RetryingTransactionHelper.RetryingTransactionCallback callback = (RetryingTransactionHelper.RetryingTransactionCallback)invocation.getArguments()[0];
                return callback.execute();
            }
        };
        ((RetryingTransactionHelper)Mockito.doAnswer((Answer)doInTransactionAnswer).when((Object)this.mockedRetryingTransactionHelper)).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.mockedTransactionService.getRetryingTransactionHelper()).thenReturn((Object)this.mockedRetryingTransactionHelper);
        Mockito.when((Object)this.mockedPatchDAO.getMaxAdmNodeID()).thenReturn((Object)500000L);
        Mockito.when((Object)this.mockedQnameDAO.getQName(ASPECT_EXTENDED_SECURITY)).thenReturn((Object)new Pair((Object)ASPECT_ID, (Object)ASPECT));
    }

    @Test
    public void noNodesWithExtendedSecurity() throws Exception {
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(Collections.emptyList());
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"3");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 0 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_READERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_WRITERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).removeAspect((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ASPECT_EXTENDED_SECURITY));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_READER"));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_WRITER"));
        ((ExtendedSecurityService)Mockito.verify((Object)this.mockedExtendedSecurityService, (VerificationMode)Mockito.never())).set((NodeRef)ArgumentMatchers.any(NodeRef.class), (Set)ArgumentMatchers.any(Set.class), (Set)ArgumentMatchers.any(Set.class));
    }

    @Test
    public void recordsWithExtendedSecurityAspect() throws Exception {
        List ids = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)true);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
        });
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"4");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 3 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_READERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_WRITERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).removeAspect((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ASPECT_EXTENDED_SECURITY));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_READER"));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_WRITER"));
        ((ExtendedSecurityService)Mockito.verify((Object)this.mockedExtendedSecurityService, (VerificationMode)Mockito.times((int)3))).set((NodeRef)ArgumentMatchers.any(NodeRef.class), (Set)ArgumentMatchers.any(Set.class), (Set)ArgumentMatchers.any(Set.class));
    }

    @Test
    public void nonRecordsWithExtendedSecurityAspect() throws Exception {
        List ids = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)false);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
        });
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"4");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 3 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_READERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_WRITERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).removeAspect((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ASPECT_EXTENDED_SECURITY));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_READER"));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_WRITER"));
        ((ExtendedSecurityService)Mockito.verify((Object)this.mockedExtendedSecurityService, (VerificationMode)Mockito.never())).set((NodeRef)ArgumentMatchers.any(NodeRef.class), (Set)ArgumentMatchers.any(Set.class), (Set)ArgumentMatchers.any(Set.class));
    }

    @Test
    public void missingBatchSizeParameter() throws Exception {
        try {
            this.executeJSONWebScript(Collections.emptyMap());
            Assert.fail((String)"Expected exception as parameter batchsize is mandatory.");
        }
        catch (WebScriptException e) {
            Assert.assertEquals((String)"If parameter batchsize is not provided then 'Bad request' should be returned.", (long)400L, (long)e.getStatus());
        }
    }

    @Test
    public void invalidBatchSizeParameter() throws Exception {
        try {
            ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"dd");
            this.executeJSONWebScript((Map<String, String>)parameters);
            Assert.fail((String)"Expected exception as parameter batchsize is invalid.");
        }
        catch (WebScriptException e) {
            Assert.assertEquals((String)"If parameter batchsize is invalid then 'Bad request' should be returned.", (long)400L, (long)e.getStatus());
        }
    }

    @Test
    public void batchSizeShouldBeGraterThanZero() throws Exception {
        try {
            ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"0");
            this.executeJSONWebScript((Map<String, String>)parameters);
            Assert.fail((String)"Expected exception as parameter batchsize is not a number greater than 0.");
        }
        catch (WebScriptException e) {
            Assert.assertEquals((String)"If parameter batchsize is not a number greater than 0 then 'Bad request' should be returned.", (long)400L, (long)e.getStatus());
        }
    }

    @Test
    public void extendedSecurityAspectNotCreated() throws Exception {
        Mockito.when((Object)this.mockedQnameDAO.getQName(ASPECT_EXTENDED_SECURITY)).thenReturn(null);
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"3");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"There where no records to be processed.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
    }

    @Test
    public void processAllRecordsWhenMaxProcessedRecordsIsZero() throws Exception {
        List ids = Stream.of(1L, 2L, 3L, 4L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)false);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
        });
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"0");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 4 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
    }

    @Test
    public void whenMaxProcessedRecordsIsMissingItDefaultsToBatchSize() throws Exception {
        List ids = Stream.of(1L, 2L, 3L, 4L, 5L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)false);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
        });
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"4");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed first 4 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
    }

    @Test
    public void recordsWithExtendedSecurityAspectAndNullWritersAndReaders() throws Exception {
        List ids = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)true);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn(null);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn(null);
        });
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"4");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 3 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ArgumentCaptor readerKeysCaptor = ArgumentCaptor.forClass(Set.class);
        ArgumentCaptor writersKeysCaptor = ArgumentCaptor.forClass(Set.class);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_READERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_WRITERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).removeAspect((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ASPECT_EXTENDED_SECURITY));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_READER"));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_WRITER"));
        ((ExtendedSecurityService)Mockito.verify((Object)this.mockedExtendedSecurityService, (VerificationMode)Mockito.times((int)3))).set((NodeRef)ArgumentMatchers.any(NodeRef.class), (Set)readerKeysCaptor.capture(), (Set)writersKeysCaptor.capture());
        List allReaderKeySets = readerKeysCaptor.getAllValues();
        List allWritersKeySets = writersKeysCaptor.getAllValues();
        for (Set keySet : allReaderKeySets) {
            Assert.assertNull((Object)keySet);
        }
        for (Set keySet : allWritersKeySets) {
            Assert.assertNull((Object)keySet);
        }
    }

    @Test
    public void recordsWithExtendedSecurityAspectAndNullWriters() throws Exception {
        List ids = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)true);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn(null);
        });
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"4");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 3 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ArgumentCaptor readerKeysCaptor = ArgumentCaptor.forClass(Set.class);
        ArgumentCaptor writersKeysCaptor = ArgumentCaptor.forClass(Set.class);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_READERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)PROP_WRITERS));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).removeAspect((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ASPECT_EXTENDED_SECURITY));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_READER"));
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)3))).clearPermission((NodeRef)ArgumentMatchers.any(NodeRef.class), (String)ArgumentMatchers.eq((Object)"ROLE_EXTENDED_WRITER"));
        ((ExtendedSecurityService)Mockito.verify((Object)this.mockedExtendedSecurityService, (VerificationMode)Mockito.times((int)3))).set((NodeRef)ArgumentMatchers.any(NodeRef.class), (Set)readerKeysCaptor.capture(), (Set)writersKeysCaptor.capture());
        List allReaderKeySets = readerKeysCaptor.getAllValues();
        List allWritersKeySets = writersKeysCaptor.getAllValues();
        for (Set keySet : allReaderKeySets) {
            Assert.assertNotNull((Object)keySet);
        }
        for (Set keySet : allWritersKeySets) {
            Assert.assertNull((Object)keySet);
        }
    }

    @Test
    public void processWithCSVFile() throws Exception {
        List ids = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)true);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            String name = "name" + i;
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, ContentModel.PROP_NAME)).thenReturn((Object)name);
        });
        ArgumentCaptor csvFileCaptor = ArgumentCaptor.forClass(File.class);
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"4", (Object)"export", (Object)"true");
        this.executeWebScript((Map<String, String>)parameters);
        ((ContentStreamer)Mockito.verify((Object)this.contentStreamer, (VerificationMode)Mockito.times((int)1))).streamContent((WebScriptRequest)ArgumentMatchers.any(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.any(WebScriptResponse.class), (File)csvFileCaptor.capture(), (Long)ArgumentMatchers.nullable(Long.class), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (String)ArgumentMatchers.any(String.class), (Map)ArgumentMatchers.any(Map.class));
        File fileForDownload = (File)csvFileCaptor.getValue();
        Assert.assertNotNull((Object)fileForDownload);
    }

    @Test
    public void processedWithouthCSVFile() throws Exception {
        List ids = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        Mockito.when((Object)this.mockedPatchDAO.getNodesByAspectQNameId((Long)ArgumentMatchers.eq((Object)ASPECT_ID), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(ids).thenReturn(Collections.emptyList());
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeDAO.getNodePair(i)).thenReturn((Object)new Pair(i, (Object)nodeRef));
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)true);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
        });
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"maxProcessedRecords", (Object)"4", (Object)"export", (Object)"false");
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 3 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ((ContentStreamer)Mockito.verify((Object)this.contentStreamer, (VerificationMode)Mockito.never())).streamContent((WebScriptRequest)ArgumentMatchers.any(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.any(WebScriptResponse.class), (File)ArgumentMatchers.any(File.class), (Long)ArgumentMatchers.any(Long.class), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (String)ArgumentMatchers.any(String.class), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void invalidParentNodeRefParameter() throws Exception {
        try {
            ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"parentNodeRef", (Object)"invalidNodeRef");
            this.executeJSONWebScript((Map<String, String>)parameters);
            Assert.fail((String)"Expected exception as parameter parentNodeRef is invalid.");
        }
        catch (WebScriptException e) {
            Assert.assertEquals((String)"If parameter parentNodeRef is invalid then 'Internal server error' should be returned.", (long)500L, (long)e.getStatus());
        }
    }

    @Test
    public void inexistentParentNodeRefParameter() throws Exception {
        try {
            NodeRef parentNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeService.exists(parentNodeRef)).thenReturn((Object)false);
            ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"10", (Object)"parentNodeRef", (Object)parentNodeRef.toString());
            this.executeJSONWebScript((Map<String, String>)parameters);
            Assert.fail((String)"Expected exception as parameter parentNodeRef does not exist.");
        }
        catch (WebScriptException e) {
            Assert.assertEquals((String)"If parameter parentNodeRef is does not exist then 'Bad Reequest' should be returned.", (long)400L, (long)e.getStatus());
        }
    }

    @Test
    public void processedWithParentNodeRef() throws Exception {
        List ids = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        NodeRef parentNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        ArrayList children = new ArrayList();
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)true);
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT)).thenReturn((Object)true);
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            String name = "name" + i;
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, ContentModel.PROP_NAME)).thenReturn((Object)name);
            FileInfo mockedFileInfo = (FileInfo)Mockito.mock(FileInfo.class);
            Mockito.when((Object)mockedFileInfo.getNodeRef()).thenReturn((Object)nodeRef);
            children.add(mockedFileInfo);
        });
        Mockito.when((Object)this.mockedFileFolderService.search((NodeRef)ArgumentMatchers.eq((Object)parentNodeRef), (String)ArgumentMatchers.eq((Object)"*"), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true))).thenReturn(children);
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"3", (Object)"maxProcessedRecords", (Object)"4", (Object)"export", (Object)"false", (Object)"parentNodeRef", (Object)parentNodeRef.toString());
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 3 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ((ContentStreamer)Mockito.verify((Object)this.contentStreamer, (VerificationMode)Mockito.never())).streamContent((WebScriptRequest)ArgumentMatchers.any(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.any(WebScriptResponse.class), (File)ArgumentMatchers.any(File.class), (Long)ArgumentMatchers.any(Long.class), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (String)ArgumentMatchers.any(String.class), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void processedWithParentNodeRefWithFirstTwoBatchesAlreadyProcessed() throws Exception {
        List ids = Stream.of(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L).collect(Collectors.toList());
        NodeRef parentNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        ArrayList children = new ArrayList();
        ids.stream().forEach(i -> {
            NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
            Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT_RECORD)).thenReturn((Object)true);
            if (i <= 6L) {
                Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT)).thenReturn((Object)false);
            } else {
                Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ASPECT)).thenReturn((Object)true);
            }
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_READERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, PROP_WRITERS)).thenReturn((Object)((Serializable)((Object)Collections.emptyMap())));
            String name = "name" + i;
            Mockito.when((Object)this.mockedNodeService.getProperty(nodeRef, ContentModel.PROP_NAME)).thenReturn((Object)name);
            FileInfo mockedFileInfo = (FileInfo)Mockito.mock(FileInfo.class);
            Mockito.when((Object)mockedFileInfo.getNodeRef()).thenReturn((Object)nodeRef);
            children.add(mockedFileInfo);
        });
        Mockito.when((Object)this.mockedFileFolderService.search((NodeRef)ArgumentMatchers.eq((Object)parentNodeRef), (String)ArgumentMatchers.eq((Object)"*"), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true))).thenReturn(children);
        ImmutableMap parameters = ImmutableMap.of((Object)"batchsize", (Object)"3", (Object)"parentNodeRef", (Object)parentNodeRef.toString());
        JSONObject json = this.executeJSONWebScript((Map<String, String>)parameters);
        Assert.assertNotNull((Object)json);
        String actualJSONString = json.toString();
        ObjectMapper mapper = new ObjectMapper();
        String expectedJSONString = "{\"responsestatus\":\"success\",\"message\":\"Processed 2 records.\"}";
        Assert.assertEquals((Object)mapper.readTree(expectedJSONString), (Object)mapper.readTree(actualJSONString));
        ((ContentStreamer)Mockito.verify((Object)this.contentStreamer, (VerificationMode)Mockito.never())).streamContent((WebScriptRequest)ArgumentMatchers.any(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.any(WebScriptResponse.class), (File)ArgumentMatchers.any(File.class), (Long)ArgumentMatchers.any(Long.class), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (String)ArgumentMatchers.any(String.class), (Map)ArgumentMatchers.any(Map.class));
    }
}

