/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.util.Optional;
import java.util.function.Supplier;

public class ExceptionUtils {
    public static <R, T extends Throwable> T expectedException(Class<T> expected, Supplier<R> code) {
        Optional<Object> maybeThrownByCode;
        try {
            code.get();
            maybeThrownByCode = Optional.empty();
        }
        catch (Throwable t) {
            maybeThrownByCode = Optional.of(t);
        }
        Throwable thrownByCode = (Throwable)maybeThrownByCode.orElseThrow(() -> new MissingThrowableException(expected));
        if (expected.isAssignableFrom(thrownByCode.getClass())) {
            return (T)thrownByCode;
        }
        throw new UnexpectedThrowableException(expected, thrownByCode);
    }

    public static <R, T extends Exception> R smuggleCheckedExceptions(ThrowingSupplier<R, T> code) {
        try {
            return code.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SmuggledException(e);
        }
    }

    public static class UnexpectedThrowableException
    extends RuntimeException {
        private static final long serialVersionUID = 3900164716673246207L;
        private final Class<? extends Throwable> expected;
        private final Throwable actual;

        public UnexpectedThrowableException(Class<? extends Throwable> expected, Throwable actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public Class<? extends Throwable> getExpected() {
            return this.expected;
        }

        public Throwable getActual() {
            return this.actual;
        }

        @Override
        public String toString() {
            return String.join((CharSequence)"", "Expected ", this.expected.getSimpleName(), " but ", this.actual.getClass().getSimpleName(), " was thrown.");
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R, T extends Exception> {
        public R get() throws T;
    }

    public static class SmuggledException
    extends RuntimeException {
        private static final long serialVersionUID = -606404592461576013L;
        private final Exception e;

        public SmuggledException(Exception e) {
            this.e = e;
        }

        public Exception getCheckedException() {
            return this.e;
        }
    }

    public static class MissingThrowableException
    extends RuntimeException {
        private static final long serialVersionUID = -988022536370047222L;
        private final Class<? extends Throwable> expected;

        public MissingThrowableException(Class<? extends Throwable> expected) {
            this.expected = expected;
        }

        public Class<? extends Throwable> getExpected() {
            return this.expected;
        }

        @Override
        public String toString() {
            return String.join((CharSequence)"", "Expected ", this.expected.getSimpleName(), " but nothing was thrown.");
        }
    }
}

