/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.unfiledcontainers;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.UnfiledContainer;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="unfiled-containers", title="Unfiled containers")
public class UnfiledContainerEntityResource
implements EntityResourceAction.ReadById<UnfiledContainer>,
EntityResourceAction.Update<UnfiledContainer>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"apiNodesModelFactory", (Object)this.nodesModelFactory);
    }

    @WebApiDescription(title="Get unfiled container information", description="Gets information for a unfiled container with id 'unfiledContainerId'")
    @WebApiParam(name="unfiledContainerId", title="The unfiled container id")
    public UnfiledContainer readById(String unfiledContainerId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledContainerId", unfiledContainerId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledContainerId, RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
        FileInfo info = this.fileFolderService.getFileInfo(nodeRef);
        return this.nodesModelFactory.createUnfiledContainer(info, parameters, null, false);
    }

    @WebApiDescription(title="Update unfiled record container", description="Updates an unfiled record container with id 'unfiledContainerId'")
    public UnfiledContainer update(String unfiledContainerId, final UnfiledContainer unfiledContainerInfo, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledContainerId", unfiledContainerId);
        ParameterCheck.mandatory((String)"unfiledContainerInfo", (Object)unfiledContainerInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledContainerId, RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                UnfiledContainerEntityResource.this.apiUtils.updateNode(nodeRef, unfiledContainerInfo, parameters);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                return UnfiledContainerEntityResource.this.fileFolderService.getFileInfo(nodeRef);
            }
        };
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, false, true);
        this.apiUtils.postActivity(info, unfiledContainerInfo.getParentId(), "org.alfresco.documentlibrary.file-updated");
        return this.nodesModelFactory.createUnfiledContainer(info, parameters, null, false);
    }
}

