/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.report;

import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.report.Report;
import org.alfresco.module.org_alfresco_module_rm.report.ReportModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.GUID;

public class HoldReportTest
extends BaseRMTestCase
implements ReportModel {
    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testHoldReportTypeAvailable() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private Set<QName> reportTypes;

            @Override
            public void when() {
                this.reportTypes = HoldReportTest.this.reportService.getReportTypes();
            }

            @Override
            public void then() {
                TestCase.assertNotNull(this.reportTypes);
                TestCase.assertTrue((boolean)this.reportTypes.contains(ReportModel.TYPE_HOLD_REPORT));
            }
        });
    }

    public void testReportedUponNodeIsNotAHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class){
            private NodeRef reportedUponNodeRef;

            @Override
            public void given() {
                this.reportedUponNodeRef = HoldReportTest.this.recordFolderService.createRecordFolder(HoldReportTest.this.rmContainer, GUID.generate());
            }

            @Override
            public void when() {
                HoldReportTest.this.reportService.generateReport(ReportModel.TYPE_HOLD_REPORT, this.reportedUponNodeRef);
            }

            @Override
            public void after() {
                HoldReportTest.this.nodeService.deleteNode(this.reportedUponNodeRef);
            }
        });
    }

    public void testGenerateHoldReport() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private static final String HOLD_NAME = "holdName";
            private static final String HOLD_REASON = "holdReason";
            private static final String HOLD_DESCRIPTION = "holdDescription";
            private static final String FOLDER1_NAME = "folder1Name";
            private NodeRef hold;
            private NodeRef folder1;
            private Report report;

            @Override
            public void given() {
                this.hold = HoldReportTest.this.holdService.createHold(HoldReportTest.this.filePlan, HOLD_NAME, HOLD_REASON, HOLD_DESCRIPTION);
                this.folder1 = HoldReportTest.this.recordFolderService.createRecordFolder(HoldReportTest.this.rmContainer, FOLDER1_NAME);
                HoldReportTest.this.holdService.addToHold(this.hold, this.folder1);
                HoldReportTest.this.holdService.addToHold(this.hold, HoldReportTest.this.recordOne);
            }

            @Override
            public void when() {
                this.report = HoldReportTest.this.reportService.generateReport(ReportModel.TYPE_HOLD_REPORT, this.hold, "text/html");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.report);
                TestCase.assertEquals((Object)ReportModel.TYPE_HOLD_REPORT, (Object)this.report.getReportType());
                TestCase.assertTrue((boolean)this.report.getReportProperties().isEmpty());
                TestCase.assertNotNull((Object)this.report.getReportName());
                TestCase.assertTrue((boolean)this.report.getReportName().contains("Hold Report"));
                TestCase.assertTrue((boolean)this.report.getReportName().contains(HOLD_NAME));
                TestCase.assertTrue((boolean)this.report.getReportName().contains(".html"));
                ContentReader reader = this.report.getReportContent();
                TestCase.assertNotNull((Object)reader);
                TestCase.assertEquals((String)"text/html", (String)reader.getMimetype());
                String reportContent = reader.getContentString();
                TestCase.assertNotNull((Object)reportContent);
                TestCase.assertTrue((boolean)reportContent.contains(HOLD_NAME));
                TestCase.assertTrue((boolean)reportContent.contains(HOLD_REASON));
                TestCase.assertTrue((boolean)reportContent.contains(HOLD_DESCRIPTION));
                TestCase.assertTrue((boolean)reportContent.contains(FOLDER1_NAME));
                TestCase.assertTrue((boolean)reportContent.contains("one"));
            }

            @Override
            public void after() {
                HoldReportTest.this.holdService.deleteHold(this.hold);
            }
        });
    }
}

