/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.annotation.BehaviourRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class BaseBehaviourBean
extends ServiceBaseImpl
implements RecordsManagementModel,
BehaviourRegistry {
    protected static final Log LOGGER = LogFactory.getLog(BaseBehaviourBean.class);
    protected static final String UNIQUE_CHILD_TYPE_ERROR = "rm.action.unique.child.type-error-message";
    protected static final String MULTIPLE_CHILDREN_TYPE_ERROR = "rm.action.multiple.children.type-error-message";
    protected BehaviourFilter behaviourFilter;
    protected Map<String, Behaviour> behaviours = new HashMap<String, Behaviour>(7);

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void registerBehaviour(String name, Behaviour behaviour) {
        if (this.behaviours.containsKey(name)) {
            throw new AlfrescoRuntimeException("Can not register behaviour, because name " + name + "has already been used.");
        }
        this.behaviours.put(name, behaviour);
    }

    public Behaviour getBehaviour(String name) {
        return this.behaviours.get(name);
    }

    protected void validateNewChildAssociation(NodeRef parent, NodeRef child, List<QName> acceptedUniqueChildType, List<QName> acceptedMultipleChildType) throws IntegrityException {
        QName childType = this.getInternalNodeService().getType(child);
        if (acceptedUniqueChildType.contains(childType)) {
            if (this.nodeService.getChildAssocs(parent, (Set)Sets.newHashSet((Object[])new QName[]{childType})).size() > 1) {
                throw new IntegrityException(I18NUtil.getMessage((String)UNIQUE_CHILD_TYPE_ERROR), null);
            }
        } else if (!acceptedMultipleChildType.contains(childType)) {
            throw new IntegrityException(I18NUtil.getMessage((String)MULTIPLE_CHILDREN_TYPE_ERROR, (Object[])new Object[]{childType}), null);
        }
    }

    protected void validateNewChildAssociationSubTypesIncluded(NodeRef child, List<QName> acceptedMultipleChildType) throws IntegrityException {
        QName childType = this.getInternalNodeService().getType(child);
        for (QName type : acceptedMultipleChildType) {
            if (!this.instanceOf(childType, type)) continue;
            return;
        }
        throw new IntegrityException(I18NUtil.getMessage((String)MULTIPLE_CHILDREN_TYPE_ERROR, (Object[])new Object[]{childType}), null);
    }
}

