/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.recordcategories;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.RecordCategory;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="record-categories", title="Record Categories")
public class RecordCategoriesEntityResource
implements EntityResourceAction.ReadById<RecordCategory>,
EntityResourceAction.Delete,
EntityResourceAction.Update<RecordCategory>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"apiNodesModelFactory", (Object)this.nodesModelFactory);
    }

    @WebApiDescription(title="Get record category information", description="Gets information for a record category with id 'recordCategoryId'")
    @WebApiParam(name="recordCategoryId", title="The record category id")
    public RecordCategory readById(String recordCategoryId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordCategoryId", recordCategoryId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        String relativePath = parameters.getParameter("relativePath");
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(recordCategoryId, RecordsManagementModel.TYPE_RECORD_CATEGORY, relativePath, true);
        FileInfo info = this.fileFolderService.getFileInfo(nodeRef);
        return this.nodesModelFactory.createRecordCategory(info, parameters, null, false);
    }

    @WebApiDescription(title="Update record category", description="Updates a record category with id 'recordCategoryId'")
    public RecordCategory update(String recordCategoryId, final RecordCategory recordCategoryInfo, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordCategoryId", recordCategoryId);
        ParameterCheck.mandatory((String)"recordCategoryInfo", (Object)recordCategoryInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(recordCategoryId, RecordsManagementModel.TYPE_RECORD_CATEGORY);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                RecordCategoriesEntityResource.this.apiUtils.updateNode(nodeRef, recordCategoryInfo, parameters);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                return RecordCategoriesEntityResource.this.fileFolderService.getFileInfo(nodeRef);
            }
        };
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, false, true);
        return this.nodesModelFactory.createRecordCategory(info, parameters, null, false);
    }

    @WebApiDescription(title="Delete record category", description="Deletes a record category with id 'recordCategoryId'")
    public void delete(String recordCategoryId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordCategoryId", recordCategoryId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(recordCategoryId, RecordsManagementModel.TYPE_RECORD_CATEGORY);
        this.fileFolderService.delete(nodeRef);
    }
}

