/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionType;

public class DeclareVersionAsRecordActionTest
extends BaseRMTestCase {
    private RuleService ruleService;
    private NodeRef ruleFile;
    protected static final String DESCRIPTION = "description";

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testUpdateNextDispositionAction_RM3060() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmContributor){
            Map<String, Serializable> versionProperties;
            Version recordedVersion;
            {
                this.versionProperties = new HashMap<String, Serializable>(4);
            }

            @Override
            public void given() {
                DeclareVersionAsRecordActionTest.this.ruleFile = DeclareVersionAsRecordActionTest.this.fileFolderService.create(DeclareVersionAsRecordActionTest.this.documentLibrary, "mytestfile", ContentModel.TYPE_CONTENT).getNodeRef();
                Action action = DeclareVersionAsRecordActionTest.this.actionService.createAction("declare-version-record");
                action.setParameterValue("file-plan", (Serializable)DeclareVersionAsRecordActionTest.this.filePlan);
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.setTitle("my rule");
                rule.setAction(action);
                rule.setExecuteAsynchronously(true);
                DeclareVersionAsRecordActionTest.this.ruleService.saveRule(DeclareVersionAsRecordActionTest.this.ruleFile, rule);
                this.versionProperties.put(DeclareVersionAsRecordActionTest.DESCRIPTION, (Serializable)((Object)DeclareVersionAsRecordActionTest.DESCRIPTION));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                this.versionProperties.put("recordable-version", Boolean.valueOf(true));
                this.versionProperties.put("file-plan", (Serializable)DeclareVersionAsRecordActionTest.this.filePlan);
            }

            @Override
            public void when() {
                this.recordedVersion = DeclareVersionAsRecordActionTest.this.versionService.createVersion(DeclareVersionAsRecordActionTest.this.ruleFile, this.versionProperties);
            }

            @Override
            public void then() throws Exception {
                NodeRef recordedVersionNodeRef = (NodeRef)this.recordedVersion.getVersionProperties().get(RecordableVersionModel.PROP_RECORD_NODE_REF.getLocalName());
                TestCase.assertNotNull((String)"Recorded version shouldn't be null.", (Object)recordedVersionNodeRef);
                TestCase.assertTrue((boolean)DeclareVersionAsRecordActionTest.this.nodeService.hasAspect(recordedVersionNodeRef, RecordableVersionModel.ASPECT_VERSION_RECORD));
            }
        });
    }
}

