/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.action;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class MoveRecordActionTest
extends BaseRMTestCase {
    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testMoveRecordAction() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef testFolder = MoveRecordActionTest.this.fileFolderService.create(MoveRecordActionTest.this.dmFolder, "myTestFolder", ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef document = MoveRecordActionTest.this.fileFolderService.create(testFolder, "moveFile.txt", ContentModel.TYPE_CONTENT).getNodeRef();
                String destination = MoveRecordActionTest.this.fileFolderService.create(testFolder, "newDest", ContentModel.TYPE_FOLDER).getNodeRef().toString();
                Action createAction = MoveRecordActionTest.this.actionService.createAction("create-record");
                createAction.setParameterValue("file-plan", (Serializable)MoveRecordActionTest.this.filePlan);
                MoveRecordActionTest.this.actionService.executeAction(createAction, document);
                TestCase.assertTrue((boolean)MoveRecordActionTest.this.recordService.isRecord(document));
                TestCase.assertNotNull((Object)MoveRecordActionTest.this.nodeService.getProperty(document, RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION));
                TestCase.assertEquals((int)MoveRecordActionTest.this.nodeService.getParentAssocs(document).size(), (int)2);
                TestCase.assertEquals((int)MoveRecordActionTest.this.nodeService.getChildAssocs(testFolder).size(), (int)2);
                Action moveRecordAction = MoveRecordActionTest.this.actionService.createAction("move-dm-record");
                moveRecordAction.setParameterValue("targetNodeRef", (Serializable)((Object)destination));
                MoveRecordActionTest.this.actionService.executeAction(moveRecordAction, document);
                TestCase.assertEquals((int)MoveRecordActionTest.this.nodeService.getChildAssocs(testFolder).size(), (int)1);
                ChildAssociationRef parent1 = (ChildAssociationRef)MoveRecordActionTest.this.nodeService.getParentAssocs(document).get(0);
                ChildAssociationRef parent2 = (ChildAssociationRef)MoveRecordActionTest.this.nodeService.getParentAssocs(document).get(1);
                NodeRef newDocParent = (parent1.isPrimary() ? parent2 : parent1).getParentRef();
                TestCase.assertEquals((String)destination, (String)newDocParent.toString());
                TestCase.assertEquals((Object)((NodeRef)MoveRecordActionTest.this.nodeService.getProperty(document, RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION)), (Object)newDocParent);
                return null;
            }
        }, this.dmCollaborator);
    }
}

