/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class AddRecordTypeAction
extends RMActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(AddRecordTypeAction.class);
    private static final String MSG_ACTIONED_UPON_NOT_RECORD = "rm.action.actioned-upon-not-record";
    private static final String DELIMITER = ",";
    public static final String PARAM_ADD_RECORD_TYPES = "recordTypes";
    public static final String NAME = "addRecordTypes";

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (this.eligibleForAction(actionedUponNodeRef)) {
            for (String type : this.getRecordTypes(action)) {
                this.getRecordService().addRecordType(actionedUponNodeRef, QName.createQName((String)type, (NamespacePrefixResolver)this.getNamespaceService()));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)I18NUtil.getMessage((String)MSG_ACTIONED_UPON_NOT_RECORD, (Object[])new Object[]{this.getClass().getSimpleName(), actionedUponNodeRef.toString()}));
        }
    }

    private boolean eligibleForAction(NodeRef actionedUponNodeRef) {
        boolean result = false;
        if (this.getNodeService().exists(actionedUponNodeRef) && !this.getFreezeService().isFrozen(actionedUponNodeRef) && this.getRecordService().isRecord(actionedUponNodeRef) && !this.getRecordService().isDeclared(actionedUponNodeRef)) {
            result = true;
        }
        return result;
    }

    private String[] getRecordTypes(Action action) {
        String recordTypes = (String)((Object)action.getParameterValue(PARAM_ADD_RECORD_TYPES));
        return recordTypes.split(DELIMITER);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_ADD_RECORD_TYPES, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_ADD_RECORD_TYPES)));
    }
}

