/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.query.RecordsManagementQueryDAO;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;

public class ContentBinDuplicationUtility
extends ServiceBaseImpl {
    private BehaviourFilter behaviourFilter;
    private ContentService contentService;
    private RecordsManagementQueryDAO recordsManagementQueryDAO;

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setRecordsManagementQueryDAO(RecordsManagementQueryDAO recordsManagementQueryDAO) {
        this.recordsManagementQueryDAO = recordsManagementQueryDAO;
    }

    public boolean hasAtLeastOneOtherReference(NodeRef nodeRef) {
        boolean hasAtLeastOneOtherReference = false;
        String contentUrl = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT).getContentUrl();
        Set<NodeRef> referencesToContentNode = this.recordsManagementQueryDAO.getNodeRefsWhichReferenceContentUrl(contentUrl);
        if (referencesToContentNode.size() > 1) {
            hasAtLeastOneOtherReference = true;
        }
        return hasAtLeastOneOtherReference;
    }

    public void duplicate(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ASPECT_ARCHIVED)) {
            this.behaviourFilter.disableBehaviour();
            try {
                this.updateContentProperty(nodeRef);
            }
            finally {
                this.behaviourFilter.enableBehaviour();
            }
        }
    }

    private void updateContentProperty(NodeRef nodeRef) {
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (reader != null) {
            ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            writer.putContent(reader);
        }
    }
}

