/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDisplayName;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipType;
import org.alfresco.module.org_alfresco_module_rm.script.CustomReferenceDefinitionBase;
import org.alfresco.util.WebScriptUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomReferenceDefinitionsGet
extends CustomReferenceDefinitionBase {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String uniqueName = WebScriptUtils.getRequestParameterValue(req, "refId", false);
        Set<RelationshipDefinition> relationshipDefinitions = this.getRelationshipDefinitons(uniqueName);
        List<Map<String, String>> relationshipDefinitionData = this.createRelationshipDefinitionData(relationshipDefinitions);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("customRefs", relationshipDefinitionData);
        return model;
    }

    private Set<RelationshipDefinition> getRelationshipDefinitons(String uniqueName) {
        HashSet<RelationshipDefinition> relationshipDefinitions = new HashSet<RelationshipDefinition>();
        if (StringUtils.isBlank((CharSequence)uniqueName)) {
            relationshipDefinitions.addAll(this.getRelationshipService().getRelationshipDefinitions());
        } else {
            RelationshipDefinition relationshipDefinition = this.getRelationshipService().getRelationshipDefinition(uniqueName);
            if (relationshipDefinition != null) {
                relationshipDefinitions.add(relationshipDefinition);
            }
        }
        return relationshipDefinitions;
    }

    private List<Map<String, String>> createRelationshipDefinitionData(Set<RelationshipDefinition> relationshipDefinitions) {
        ArrayList<Map<String, String>> relationshipDefinitionData = new ArrayList<Map<String, String>>();
        for (RelationshipDefinition relationshipDefinition : relationshipDefinitions) {
            HashMap<String, String> data = new HashMap<String, String>();
            RelationshipType type = relationshipDefinition.getType();
            RelationshipDisplayName displayName = relationshipDefinition.getDisplayName();
            if (RelationshipType.BIDIRECTIONAL.equals((Object)type)) {
                data.put("label", displayName.getSourceText());
            } else if (RelationshipType.PARENTCHILD.equals((Object)type)) {
                data.put("source", displayName.getSourceText());
                data.put("target", displayName.getTargetText());
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Unsupported relationship type '").append((Object)type).append("'.");
                throw new WebScriptException(400, sb.toString());
            }
            data.put("refId", relationshipDefinition.getUniqueName());
            data.put("referenceType", type.toString().toLowerCase());
            relationshipDefinitionData.add(data);
        }
        return relationshipDefinitionData;
    }
}

