/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.recordableversion;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.recordableversion.RecordableVersionConfigService;
import org.alfresco.module.org_alfresco_module_rm.script.slingshot.Version;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;

public class RecordableVersionConfigServiceImpl
implements RecordableVersionConfigService,
RecordableVersionModel {
    private NodeService nodeService;

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public List<Version> getVersions(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        RecordableVersionPolicy[] recordableVersionPolicies = RecordableVersionPolicy.values();
        ArrayList<Version> versions = new ArrayList<Version>(recordableVersionPolicies.length);
        for (RecordableVersionPolicy recordableVersionPolicy : recordableVersionPolicies) {
            String policy = recordableVersionPolicy.toString();
            boolean selected = this.isVersionPolicySelected(recordableVersionPolicy, nodeRef);
            versions.add(new Version(policy, selected));
        }
        return versions;
    }

    @Override
    public void setVersion(NodeRef nodeRef, String version) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatoryString((String)"recordedVersion", (String)version);
        RecordableVersionPolicy recordableVersionPolicy = RecordableVersionPolicy.valueOf(version);
        this.getNodeService().setProperty(nodeRef, PROP_RECORDABLE_VERSION_POLICY, (Serializable)((Object)recordableVersionPolicy));
    }

    private boolean isVersionPolicySelected(RecordableVersionPolicy recordableVersionPolicy, NodeRef nodeRef) {
        boolean isVersionPolicySelected = false;
        String policy = (String)((Object)this.getNodeService().getProperty(nodeRef, PROP_RECORDABLE_VERSION_POLICY));
        if (StringUtils.isNotBlank((CharSequence)policy)) {
            if (RecordableVersionPolicy.valueOf(policy).equals((Object)recordableVersionPolicy)) {
                isVersionPolicySelected = true;
            }
        } else if (recordableVersionPolicy.equals((Object)RecordableVersionPolicy.NONE)) {
            isVersionPolicySelected = true;
        }
        return isVersionPolicySelected;
    }
}

