/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.script.slingshot.ClassificationReasonsUtil;
import org.alfresco.module.org_alfresco_module_rm.script.slingshot.RecordCategoryUtil;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchParameters;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetailsCompatibility;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RMSearchGet
extends DeclarativeWebScript {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMSearchGet.class);
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_SORTBY = "sortby";
    private static final String PARAM_FILTERS = "filters";
    private static final String PARAM_MAX_ITEMS = "maxitems";
    private static final String SYSTEM = "System";
    protected RecordsManagementSearchService recordsManagementSearchService;
    protected SiteService siteService;
    protected NamespaceService namespaceService;
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PermissionService permissionService;
    protected PersonService personService;
    private Map<String, String> personDataCache = null;
    private RecordCategoryUtil recordCategoryUtil;
    private ClassificationReasonsUtil classificationReasonsUtil;

    public void setRecordsManagementSearchService(RecordsManagementSearchService recordsManagementSearchService) {
        this.recordsManagementSearchService = recordsManagementSearchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setRecordCategoryUtil(RecordCategoryUtil recordCategoryUtil) {
        this.recordCategoryUtil = recordCategoryUtil;
    }

    public void setClassificationReasonsUtil(ClassificationReasonsUtil classificationReasonsUtil) {
        this.classificationReasonsUtil = classificationReasonsUtil;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        try {
            Map templateVars = req.getServiceMatch().getTemplateVars();
            String siteId = (String)templateVars.get("site");
            if (siteId == null || siteId.length() == 0) {
                throw new WebScriptException(400, "Site id not provided.");
            }
            if (this.siteService.getSite(siteId) == null) {
                throw new WebScriptException(404, "Site not found.");
            }
            String query = req.getParameter(PARAM_QUERY);
            String sortby = req.getParameter(PARAM_SORTBY);
            String filters = req.getParameter(PARAM_FILTERS);
            if (query.contains("clf:classificationReasons:")) {
                query = this.classificationReasonsUtil.replaceReasonWithNodeRef(query);
            }
            RecordsManagementSearchParameters searchParameters = SavedSearchDetailsCompatibility.createSearchParameters(filters, new String[]{",", "/"}, sortby, this.namespaceService);
            String maxItems = req.getParameter(PARAM_MAX_ITEMS);
            if (maxItems != null && maxItems.length() != 0) {
                searchParameters.setMaxItems(Integer.parseInt(maxItems));
            }
            List<Pair<NodeRef, NodeRef>> results = this.recordsManagementSearchService.search(siteId, query, searchParameters);
            this.personDataCache = new HashMap<String, String>(57);
            ArrayList<Item> items = new ArrayList<Item>(results.size());
            for (Pair<NodeRef, NodeRef> pair : results) {
                try {
                    Item item = new Item((NodeRef)pair.getFirst(), (NodeRef)pair.getSecond());
                    items.add(item);
                }
                catch (Exception e) {
                    LOGGER.debug("Ignoring failed attempt to add item to search results.", (Throwable)e);
                }
            }
            model.put("items", items);
        }
        catch (Exception ex) {
            model.put("errorMessage", ex.toString());
        }
        return model;
    }

    public class Item {
        private NodeRef nodeRef;
        private String type;
        private int size;
        private String parentFolder = "";
        private String browseUrl;
        private boolean isContainer;
        private String modifiedBy;
        private String createdBy;
        private Map<QName, Serializable> nodeProperties;
        private Map<String, Serializable> properties;
        private String recordCategoryId;

        public Item(NodeRef parent, NodeRef nodeRef) {
            this.nodeRef = nodeRef;
            QName nodeRefType = RMSearchGet.this.nodeService.getType(nodeRef);
            this.type = nodeRefType.toPrefixString((NamespacePrefixResolver)RMSearchGet.this.namespaceService);
            this.nodeProperties = RMSearchGet.this.nodeService.getProperties(nodeRef);
            this.isContainer = true;
            if (RMSearchGet.this.dictionaryService.isSubClass(nodeRefType, ContentModel.TYPE_CONTENT)) {
                this.isContainer = false;
            }
            if (this.isContainer) {
                this.size = -1;
                String displayPath = RMSearchGet.this.nodeService.getPath(nodeRef).toDisplayPath(RMSearchGet.this.nodeService, RMSearchGet.this.permissionService);
                Object[] pathElements = displayPath.split("/");
                if (pathElements.length >= 5) {
                    String newPath;
                    StringBuilder relPath;
                    if (pathElements.length > 5) {
                        this.parentFolder = (String)((Object)RMSearchGet.this.nodeService.getProperty(parent, ContentModel.PROP_NAME));
                    }
                    if ((relPath = new StringBuilder("/").append(newPath = StringUtils.join((Object[])(pathElements = (String[])ArrayUtils.subarray((Object[])pathElements, (int)5, (int)pathElements.length)), (String)"/"))).length() > 1) {
                        relPath.append("/");
                    }
                    relPath.append(this.getName());
                    try {
                        this.browseUrl = "documentlibrary?path=" + URLEncoder.encode(relPath.toString(), "UTF-8").replaceAll("\\+", "%20");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AlfrescoRuntimeException("Could not process search results.", (Throwable)e);
                    }
                }
            } else {
                ContentData contentData = (ContentData)this.nodeProperties.get(ContentModel.PROP_CONTENT);
                this.size = 0;
                if (contentData != null) {
                    this.size = (int)contentData.getSize();
                }
                if (parent != null) {
                    this.parentFolder = (String)((Object)RMSearchGet.this.nodeService.getProperty(parent, ContentModel.PROP_NAME));
                }
                this.browseUrl = "document-details?nodeRef=" + nodeRef.toString();
            }
            this.modifiedBy = this.getDisplayName(this.getModifiedByUser());
            this.createdBy = this.getDisplayName(this.getCreatedByUser());
            this.properties = new HashMap<String, Serializable>(this.nodeProperties.size());
            for (Map.Entry<QName, Serializable> entry : this.nodeProperties.entrySet()) {
                QName qName = entry.getKey().getPrefixedQName((NamespacePrefixResolver)RMSearchGet.this.namespaceService);
                if ("http://www.alfresco.org/model/system/1.0".equals(qName.getNamespaceURI())) continue;
                String prefixName = qName.getPrefixString().replace(":", "_");
                this.properties.put(prefixName, entry.getValue());
            }
            this.properties.put("rma_recordCategoryIdentifier", (Serializable)((Object)RMSearchGet.this.recordCategoryUtil.getCategoryIdFromNodeId(nodeRef, false)));
        }

        private String getDisplayName(String userName) {
            if (userName.equals(RMSearchGet.SYSTEM)) {
                return RMSearchGet.SYSTEM;
            }
            String result = RMSearchGet.this.personDataCache.get(userName);
            if (result == null) {
                NodeRef person = RMSearchGet.this.personService.getPerson(userName);
                if (person != null) {
                    StringBuilder displayName = new StringBuilder(128);
                    displayName.append(RMSearchGet.this.nodeService.getProperty(person, ContentModel.PROP_FIRSTNAME)).append(" ").append(RMSearchGet.this.nodeService.getProperty(person, ContentModel.PROP_LASTNAME));
                    result = displayName.toString();
                } else {
                    result = userName;
                }
                RMSearchGet.this.personDataCache.put(userName, result);
            }
            return result;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return (String)((Object)this.nodeProperties.get(ContentModel.PROP_NAME));
        }

        public String getTitle() {
            return (String)((Object)this.nodeProperties.get(ContentModel.PROP_TITLE));
        }

        public String getDescription() {
            return (String)((Object)this.nodeProperties.get(ContentModel.PROP_DESCRIPTION));
        }

        public Date getModifiedOn() {
            return (Date)this.nodeProperties.get(ContentModel.PROP_MODIFIED);
        }

        public String getModifiedByUser() {
            return (String)((Object)this.nodeProperties.get(ContentModel.PROP_MODIFIER));
        }

        public String getModifiedBy() {
            return this.modifiedBy;
        }

        public Date getCreatedOn() {
            return (Date)this.nodeProperties.get(ContentModel.PROP_CREATED);
        }

        public String getCreatedByUser() {
            return (String)((Object)this.nodeProperties.get(ContentModel.PROP_CREATOR));
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public String getAuthor() {
            return (String)((Object)this.nodeProperties.get(ContentModel.PROP_AUTHOR));
        }

        public String getParentFolder() {
            return this.parentFolder;
        }

        public int getSize() {
            return this.size;
        }

        public String getBrowseUrl() {
            return this.browseUrl;
        }

        public Map<String, Serializable> getProperties() {
            return this.properties;
        }

        public String getRecordCategoryId() {
            return this.recordCategoryId;
        }

        public void setRecordCategoryId(String recordCategoryId) {
            this.recordCategoryId = recordCategoryId;
        }
    }
}

