/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.security;

import java.util.HashSet;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class FilePlanPermissionServiceImplUnitTest
extends BaseUnitTest {
    protected static final String AUTHORITY = "anAuthority";
    protected static final String AUTHORITY2 = "anOtherAuthority";
    protected NodeRef rootRecordCategory;
    protected NodeRef recordCategory;
    protected NodeRef newRecordFolder;
    protected NodeRef newRecord;
    protected NodeRef unfiledRecordContainer;
    protected NodeRef unfiledRecordFolder;
    protected NodeRef unfiledRecordFolderChild;
    protected NodeRef unfiledRecord;
    protected NodeRef holdContainer;
    protected NodeRef hold;
    protected NodeRef heldRecord;
    @Spy
    @InjectMocks
    FilePlanPermissionServiceImpl filePlanPermissionService;

    @Override
    public void before() throws Exception {
        super.before();
        this.unfiledRecordContainer = this.generateContainerNodeRef(TYPE_UNFILED_RECORD_CONTAINER);
        this.unfiledRecordFolder = this.generateContainerNodeRef(TYPE_UNFILED_RECORD_FOLDER);
        this.unfiledRecordFolderChild = this.generateContainerNodeRef(TYPE_UNFILED_RECORD_FOLDER);
        this.unfiledRecord = this.generateRecord();
        this.holdContainer = this.generateContainerNodeRef(TYPE_HOLD_CONTAINER);
        this.hold = this.generateHoldNodeRef("my test hold");
        this.heldRecord = this.generateRecord();
        this.rootRecordCategory = this.generateContainerNodeRef(TYPE_RECORD_CATEGORY);
        this.recordCategory = this.generateContainerNodeRef(TYPE_RECORD_CATEGORY);
        this.newRecordFolder = this.generateRecordFolder();
        this.newRecord = this.generateRecord();
        this.makePrimaryParentOf(this.filePlan, this.generateNodeRef(ContentModel.TYPE_FOLDER));
        this.makePrimaryParentOf(this.rootRecordCategory, this.filePlan);
        this.makePrimaryParentOf(this.recordCategory, this.rootRecordCategory);
        this.makePrimaryParentOf(this.newRecordFolder, this.recordCategory);
        this.makePrimaryParentOf(this.newRecord, this.newRecordFolder);
        this.makePrimaryParentOf(this.unfiledRecordFolder, this.unfiledRecordContainer);
        this.makePrimaryParentOf(this.unfiledRecordContainer, this.filePlan);
        this.makePrimaryParentOf(this.hold, this.holdContainer);
        this.makePrimaryParentOf(this.holdContainer, this.filePlan);
        this.makeChildrenOf(this.filePlan, this.rootRecordCategory);
        this.makeChildrenOf(this.rootRecordCategory, this.recordCategory);
        this.makeChildrenOf(this.recordCategory, this.newRecordFolder);
        this.makeChildrenOf(this.newRecordFolder, this.newRecord);
        this.makeChildrenOf(this.unfiledRecordFolder, this.unfiledRecordFolderChild);
        this.makeChildrenOf(this.unfiledRecordFolderChild, this.unfiledRecord);
        this.makeChildrenOf(this.holdContainer, this.hold);
        this.makeChildrenOf(this.hold, this.heldRecord);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.FILE_PLAN).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.filePlan);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.RECORD_CATEGORY).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.rootRecordCategory);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.RECORD_CATEGORY).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.recordCategory);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.RECORD_FOLDER).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.newRecordFolder);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.RECORD).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.newRecord);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.UNFILED_RECORD_FOLDER).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.unfiledRecordFolder);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.UNFILED_RECORD_CONTAINER).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.unfiledRecordContainer);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.RECORD).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.unfiledRecord);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.HOLD_CONTAINER).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.holdContainer);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)FilePlanComponentKind.HOLD).when((Object)this.filePlanPermissionService)).getFilePlanComponentKind(this.hold);
    }

    private NodeRef generateContainerNodeRef(QName type) {
        NodeRef nodeRef = this.generateNodeRef(type);
        this.setupAsFilePlanComponent(nodeRef);
        ((FilePlanPermissionServiceImpl)Mockito.doReturn((Object)true).when((Object)this.filePlanPermissionService)).isFilePlanContainer(nodeRef);
        return nodeRef;
    }

    @Test
    public void setReadPermissionOnUnfiledRecordFolder() {
        this.filePlanPermissionService.setPermission(this.unfiledRecordFolder, AUTHORITY, "ReadRecords");
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)1))).setPermission(this.unfiledRecordFolder, AUTHORITY, "ReadRecords", true);
    }

    @Test
    public void setReadAndFilePermissionOnUnfileRecordFolder() {
        this.filePlanPermissionService.setPermission(this.unfiledRecordFolder, AUTHORITY, "Filing");
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)1))).setPermission(this.unfiledRecordFolder, AUTHORITY, "Filing", true);
    }

    @Test
    public void deletePermissionFromUnfiledRecordFolder() {
        this.filePlanPermissionService.deletePermission(this.unfiledRecordFolder, AUTHORITY, "ReadRecords");
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)1))).deletePermission(this.unfiledRecordFolder, AUTHORITY, "ReadRecords");
    }

    @Test
    public void setReadPermissionOnHoldContainer() {
        this.filePlanPermissionService.setPermission(this.holdContainer, AUTHORITY, "ReadRecords");
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)1))).setPermission(this.holdContainer, AUTHORITY, "ReadRecords", true);
    }

    @Test
    public void setFilingPermissionOnHoldContainer() {
        this.filePlanPermissionService.setPermission(this.holdContainer, AUTHORITY, "Filing");
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)1))).setPermission(this.holdContainer, AUTHORITY, "Filing", true);
    }

    @Test
    public void setReadPermissionOnHold() {
        this.filePlanPermissionService.setPermission(this.hold, AUTHORITY, "ReadRecords");
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)1))).setPermission(this.hold, AUTHORITY, "ReadRecords", true);
    }

    @Test
    public void setFilingPermissionOnHold() {
        this.filePlanPermissionService.setPermission(this.hold, AUTHORITY, "Filing");
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)1))).setPermission(this.hold, AUTHORITY, "Filing", true);
    }

    private void setupPermissions(NodeRef nodeRef) {
        HashSet<AccessPermissionImpl> perms = new HashSet<AccessPermissionImpl>(4);
        perms.add(new AccessPermissionImpl("ReadRecords", AccessStatus.ALLOWED, AUTHORITY, 0));
        perms.add(new AccessPermissionImpl("Filing", AccessStatus.ALLOWED, AUTHORITY2, 1));
        ((PermissionService)Mockito.doReturn(perms).when((Object)this.mockedPermissionService)).getAllSetPermissions(nodeRef);
    }

    private void verifyInitPermissions(NodeRef nodeRef, boolean isInherited) {
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).getAllSetPermissions(nodeRef);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).setInheritParentPermissions(nodeRef, isInherited);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).clearPermission(nodeRef, null);
        ((OwnableService)Mockito.verify((Object)this.mockedOwnableService)).setOwner(nodeRef, "");
    }

    private void verifyInitPermissions(NodeRef parent, NodeRef child, VerificationMode read, VerificationMode filling, boolean isParentFilePlan, boolean isInherited) {
        this.verifyInitPermissions(child, isInherited);
        if (isParentFilePlan) {
            ((PermissionService)Mockito.verify((Object)this.mockedPermissionService)).getAllSetPermissions(parent);
            ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)filling)).setPermission(child, AUTHORITY2, "Filing", true);
            ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)read)).setPermission(child, AUTHORITY, "ReadRecords", true);
        }
    }

    @Test
    public void initPermissionsForNewRootRecordCategory() {
        this.setupPermissions(this.filePlan);
        this.filePlanPermissionService.setupRecordCategoryPermissions(this.rootRecordCategory);
        this.verifyInitPermissions(this.filePlan, this.rootRecordCategory, Mockito.never(), Mockito.times((int)1), true, false);
    }

    @Test
    public void initPermissionsForNewRecordCategory() {
        this.setupPermissions(this.rootRecordCategory);
        this.filePlanPermissionService.setupRecordCategoryPermissions(this.recordCategory);
        this.verifyInitPermissions(this.rootRecordCategory, this.recordCategory, Mockito.times((int)1), Mockito.times((int)1), false, true);
    }

    @Test
    public void initPermissionsForNewRecordFolder() {
        this.setupPermissions(this.recordCategory);
        this.filePlanPermissionService.setupPermissions(this.recordCategory, this.newRecordFolder);
        this.verifyInitPermissions(this.recordCategory, this.newRecordFolder, Mockito.times((int)1), Mockito.times((int)1), false, true);
    }

    @Test
    public void initPermissionsForNewRecord() {
        this.setupPermissions(this.newRecordFolder);
        this.filePlanPermissionService.setupPermissions(this.newRecordFolder, this.newRecord);
        this.verifyInitPermissions(this.newRecordFolder, this.newRecord, Mockito.times((int)1), Mockito.times((int)1), false, true);
    }

    @Test
    public void initPermnissionsForNewHoldContainer() {
        this.setupPermissions(this.filePlan);
        this.filePlanPermissionService.setupPermissions(this.filePlan, this.holdContainer);
        this.verifyInitPermissions(this.filePlan, this.holdContainer, Mockito.times((int)1), Mockito.times((int)1), false, true);
    }

    @Test
    public void initPermissionsForNewHold() {
        this.setupPermissions(this.holdContainer);
        this.filePlanPermissionService.setupPermissions(this.holdContainer, this.hold);
        this.verifyInitPermissions(this.holdContainer, this.hold, Mockito.never(), Mockito.times((int)1), false, false);
    }

    @Test
    public void initPermissionsForNewUnfiledContainer() {
        this.setupPermissions(this.filePlan);
        this.filePlanPermissionService.setupPermissions(this.filePlan, this.unfiledRecordContainer);
        this.verifyInitPermissions(this.filePlan, this.unfiledRecordContainer, Mockito.times((int)1), Mockito.times((int)1), false, false);
    }

    @Test
    public void initPermissionsForNewUnfiledRecordFolder() {
        this.setupPermissions(this.unfiledRecordContainer);
        this.filePlanPermissionService.setupPermissions(this.unfiledRecordContainer, this.unfiledRecordFolder);
        this.verifyInitPermissions(this.unfiledRecordContainer, this.unfiledRecordFolder, Mockito.never(), Mockito.times((int)1), false, true);
    }

    @Test
    public void initPermissionsForNewUnfiledRecord() {
        this.setupPermissions(this.unfiledRecordFolder);
        this.filePlanPermissionService.setupPermissions(this.unfiledRecordFolder, this.unfiledRecord);
        this.verifyInitPermissions(this.unfiledRecordFolder, this.unfiledRecord, Mockito.times((int)1), Mockito.times((int)1), false, true);
    }
}

