/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.patch.ModulePatch;
import org.alfresco.module.org_alfresco_module_rm.patch.ModulePatchExecuter;
import org.alfresco.repo.module.AbstractModuleComponent;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModulePatchExecuterImpl
extends AbstractModuleComponent
implements ModulePatchExecuter {
    protected static final Log LOGGER = LogFactory.getLog(ModulePatchExecuterImpl.class);
    private static final int START_SCHEMA = 0;
    private static final String KEY_MODULE_SCHEMA = "module-schema";
    protected int moduleSchema = 0;
    protected AttributeService attributeService;
    protected Map<String, ModulePatch> modulePatches = new HashMap<String, ModulePatch>(21);

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setModuleSchema(int moduleSchema) {
        this.moduleSchema = moduleSchema;
    }

    @Override
    public void register(ModulePatch modulePatch) {
        if (!this.getModuleId().equals(modulePatch.getModuleId())) {
            throw new AlfrescoRuntimeException("Unable to register module patch, becuase module id is invalid.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Registering module patch " + modulePatch.getId() + " for module " + this.getModuleId()));
        }
        this.modulePatches.put(modulePatch.getId(), modulePatch);
    }

    protected void executeInternal() {
        int currentSchema = this.getCurrentSchema();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Running module patch executer (currentSchema=" + currentSchema + ", configuredSchema=" + this.moduleSchema + ")"));
        }
        if (this.moduleSchema > currentSchema) {
            ArrayList<ModulePatch> patchesToApply = new ArrayList<ModulePatch>(13);
            for (ModulePatch modulePatch : this.modulePatches.values()) {
                if (modulePatch.getFixesFromSchema() > currentSchema || modulePatch.getFixesToSchema() < currentSchema) continue;
                patchesToApply.add(modulePatch);
            }
            Collections.sort(patchesToApply);
            for (ModulePatch patchToApply : patchesToApply) {
                patchToApply.apply();
            }
            this.updateSchema(this.moduleSchema);
        }
    }

    protected int getCurrentSchema() {
        Integer result = 0;
        if (this.attributeService.exists(new Serializable[]{KEY_MODULE_SCHEMA, this.getModuleId()})) {
            result = (Integer)this.attributeService.getAttribute(new Serializable[]{KEY_MODULE_SCHEMA, this.getModuleId()});
        }
        return result;
    }

    protected void updateSchema(int newSchema) {
        this.attributeService.setAttribute((Serializable)Integer.valueOf(newSchema), new Serializable[]{KEY_MODULE_SCHEMA, this.getModuleId()});
    }

    @Override
    public void initSchemaVersion() {
        this.updateSchema(this.moduleSchema);
    }
}

