/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.alfresco.module.org_alfresco_module_rm.action.impl.BroadcastDispositionActionDefinitionUpdateAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BroadcastDispositionActionDefinitionUpdateActionUnitTest {
    private static final NodeRef DISPOSITION_ACTION_DEF_NODE = new NodeRef("disposition://Action/Def");
    private static final NodeRef NEXT_ACTION_NODE_REF = new NodeRef("next://Step/");
    private static final NodeRef CONTENT_NODE_REF = new NodeRef("content://Node/Ref");
    private BroadcastDispositionActionDefinitionUpdateAction action = new BroadcastDispositionActionDefinitionUpdateAction();
    private NodeService mockNodeService = (NodeService)Mockito.mock(NodeService.class);
    private DispositionService mockDispositionService = (DispositionService)Mockito.mock(DispositionService.class);
    private BehaviourFilter mockBehaviourFilter = (BehaviourFilter)Mockito.mock(BehaviourFilter.class);

    @Before
    public void setUp() {
        this.action.setNodeService(this.mockNodeService);
        this.action.setDispositionService(this.mockDispositionService);
        this.action.setBehaviourFilter(this.mockBehaviourFilter);
        ChildAssociationRef mockAssocRef = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(NEXT_ACTION_NODE_REF)).thenReturn((Object)mockAssocRef);
        Mockito.when((Object)mockAssocRef.getParentRef()).thenReturn((Object)CONTENT_NODE_REF);
    }

    @Test
    public void testPersistPeriodChanges() {
        DispositionAction mockAction = (DispositionAction)Mockito.mock(DispositionAction.class);
        Mockito.when((Object)mockAction.getNodeRef()).thenReturn((Object)NEXT_ACTION_NODE_REF);
        DispositionActionDefinition mockDispositionActionDefinition = (DispositionActionDefinition)Mockito.mock(DispositionActionDefinition.class);
        Mockito.when((Object)mockAction.getDispositionActionDefinition()).thenReturn((Object)mockDispositionActionDefinition);
        Mockito.when((Object)mockAction.getName()).thenReturn((Object)"mockAction");
        Date asOfDate = new Date();
        Mockito.when((Object)this.mockDispositionService.calculateAsOfDate(CONTENT_NODE_REF, mockDispositionActionDefinition)).thenReturn((Object)asOfDate);
        this.action.persistPeriodChanges(DISPOSITION_ACTION_DEF_NODE, mockAction);
        ((NodeService)Mockito.verify((Object)this.mockNodeService)).setProperty(NEXT_ACTION_NODE_REF, RecordsManagementModel.PROP_DISPOSITION_AS_OF, (Serializable)asOfDate);
    }

    @Test
    public void testChangePeriodProperty() {
        String definitionNodeId = "definitionNodeId";
        NodeRef definitionNode = new NodeRef("definition://node/" + definitionNodeId);
        DispositionSchedule mockDispositionSchedule = (DispositionSchedule)Mockito.mock(DispositionSchedule.class);
        Mockito.when((Object)mockDispositionSchedule.getNodeRef()).thenReturn((Object)definitionNode);
        Mockito.when((Object)this.mockNodeService.getType(definitionNode)).thenReturn((Object)RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
        NodeRef categoryNode = new NodeRef("category://node/");
        NodeRef scheduleNode = new NodeRef("schedule://node/");
        ChildAssociationRef scheduleDefinitionRelationship = new ChildAssociationRef(null, scheduleNode, null, definitionNode);
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(definitionNode)).thenReturn((Object)scheduleDefinitionRelationship);
        ChildAssociationRef categoryScheduleRelationship = new ChildAssociationRef(null, categoryNode, null, scheduleNode);
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(scheduleNode)).thenReturn((Object)categoryScheduleRelationship);
        NodeRef recordNode = new NodeRef("record://node/");
        NodeRef stepNode = new NodeRef("step://node/");
        ChildAssociationRef recordStepRelationship = new ChildAssociationRef(null, recordNode, null, stepNode);
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(stepNode)).thenReturn((Object)recordStepRelationship);
        Mockito.when((Object)this.mockDispositionService.getAssociatedDispositionSchedule(categoryNode)).thenReturn((Object)mockDispositionSchedule);
        Mockito.when((Object)this.mockDispositionService.getDisposableItems(mockDispositionSchedule)).thenReturn(Arrays.asList(recordNode));
        Mockito.when((Object)this.mockDispositionService.getDispositionSchedule(recordNode)).thenReturn((Object)mockDispositionSchedule);
        Mockito.when((Object)this.mockNodeService.hasAspect(recordNode, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE)).thenReturn((Object)true);
        DispositionAction nextAction = (DispositionAction)Mockito.mock(DispositionAction.class);
        Mockito.when((Object)nextAction.getId()).thenReturn((Object)definitionNodeId);
        Mockito.when((Object)nextAction.getNodeRef()).thenReturn((Object)stepNode);
        Mockito.when((Object)this.mockDispositionService.getNextDispositionAction(recordNode)).thenReturn((Object)nextAction);
        DispositionActionDefinition mockActionDefinition = (DispositionActionDefinition)Mockito.mock(DispositionActionDefinition.class);
        Mockito.when((Object)nextAction.getDispositionActionDefinition()).thenReturn((Object)mockActionDefinition);
        Action mockAction = (Action)Mockito.mock(Action.class);
        Mockito.when((Object)mockAction.getParameterValue("changedProperties")).thenReturn((Object)((Serializable)((Object)Arrays.asList(RecordsManagementModel.PROP_DISPOSITION_PERIOD_PROPERTY))));
        Date newAsOfDate = new Date(123456789000L);
        Mockito.when((Object)this.mockDispositionService.calculateAsOfDate(recordNode, mockActionDefinition)).thenReturn((Object)newAsOfDate);
        this.action.executeImpl(mockAction, definitionNode);
        ((NodeService)Mockito.verify((Object)this.mockNodeService)).setProperty(stepNode, RecordsManagementModel.PROP_DISPOSITION_AS_OF, (Serializable)newAsOfDate);
    }
}

