/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.RmSiteType;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.MockAuthenticationUtilHelper;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RmSiteTypeUnitTest
extends BaseUnitTest
implements DOD5015Model {
    @Mock
    private AuthenticationUtil mockAuthenticationUtil;
    @Mock
    private SiteService mockedSiteService;
    @InjectMocks
    private RmSiteType rmSiteType;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        MockAuthenticationUtilHelper.setup(this.mockAuthenticationUtil);
    }

    @Test(expected=IntegrityException.class)
    public void testAddNonAcceptedTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_RM_SITE, true);
        QName type = AlfMock.generateQName();
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)rmSiteNodeRef);
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddOneFolderTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_RM_SITE, true);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FOLDER);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FOLDER}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddTwoFolderTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_RM_SITE, true);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FOLDER);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FOLDER}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
        nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FOLDER);
        mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FOLDER}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddMoreThanTwhoFolderTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_RM_SITE, true);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FOLDER}))).thenReturn(new ArrayList());
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FOLDER);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FOLDER}))).thenReturn(assocs);
        nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FOLDER);
        mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FOLDER}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
        nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FOLDER);
        mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FOLDER}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddOneFilePlanTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_RM_SITE, true);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FILE_PLAN);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FILE_PLAN}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test(expected=IntegrityException.class)
    public void testAddDODFilePlanTypeToStandardRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_RM_SITE, true);
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_DOD_5015_FILE_PLAN);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test(expected=IntegrityException.class)
    public void testAddMoreThanOneFilePlanTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_RM_SITE, true);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FILE_PLAN);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FILE_PLAN}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
        nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FILE_PLAN);
        mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_FILE_PLAN}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddOneDODFilePlanTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_DOD_5015_SITE, true);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)rmSiteNodeRef);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_DOD_5015_SITE, TYPE_RM_SITE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_DOD_5015_FILE_PLAN, TYPE_FILE_PLAN)).thenReturn((Object)true);
        this.rmSiteType.registerFilePlanType(TYPE_DOD_5015_SITE, TYPE_DOD_5015_FILE_PLAN);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_DOD_5015_FILE_PLAN);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_DOD_5015_FILE_PLAN}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test(expected=IntegrityException.class)
    public void testAddMoreThanOneDODFilePlanTypeToRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_DOD_5015_SITE, true);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)rmSiteNodeRef);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_DOD_5015_SITE, TYPE_RM_SITE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_DOD_5015_FILE_PLAN, TYPE_FILE_PLAN)).thenReturn((Object)true);
        this.rmSiteType.registerFilePlanType(TYPE_DOD_5015_SITE, TYPE_DOD_5015_FILE_PLAN);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_DOD_5015_FILE_PLAN);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_DOD_5015_FILE_PLAN}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
        nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_DOD_5015_FILE_PLAN);
        mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        assocs.add(mockedChildAssoc);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(rmSiteNodeRef, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_DOD_5015_FILE_PLAN}))).thenReturn(assocs);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test(expected=IntegrityException.class)
    public void testAddStandardFilePlanTypeToDODRmSite() {
        NodeRef rmSiteNodeRef = this.generateNodeRef(TYPE_DOD_5015_SITE, true);
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)rmSiteNodeRef);
        Mockito.when((Object)this.mockedSiteService.getSite(rmSiteNodeRef)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedApplicationContext.getBean("dbNodeService")).thenReturn((Object)this.mockedNodeService);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_DOD_5015_SITE, TYPE_RM_SITE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_DOD_5015_FILE_PLAN, TYPE_FILE_PLAN)).thenReturn((Object)true);
        this.rmSiteType.registerFilePlanType(TYPE_DOD_5015_SITE, TYPE_DOD_5015_FILE_PLAN);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, TYPE_FILE_PLAN);
        ChildAssociationRef mockedChildAssoc = this.generateChildAssociationRef(rmSiteNodeRef, nodeRef);
        this.rmSiteType.onCreateChildAssociation(mockedChildAssoc, true);
    }
}

