/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.util.PropertyMap;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.GUID;

public class RejectRecordTest
extends BaseRMTestCase {
    private VersionService versionService;
    private CheckOutCheckInService checkOutCheckInService;
    private static final String REASON = GUID.generate();
    private static final String FINAL_VERSION = "rm.service.final-version";

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected void initServices() {
        super.initServices();
        this.versionService = (VersionService)this.applicationContext.getBean("VersionService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("CheckOutCheckInService");
    }

    public void testRejectedRecordInCorrectState() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                TestCase.assertFalse((boolean)RejectRecordTest.this.recordService.isRecord(RejectRecordTest.this.dmDocument));
                RejectRecordTest.this.ownableService.setOwner(RejectRecordTest.this.dmDocument, RejectRecordTest.this.userName);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RejectRecordTest.this.recordService.createRecord(RejectRecordTest.this.filePlan, RejectRecordTest.this.dmDocument);
                        return null;
                    }
                }, (String)RejectRecordTest.this.userName);
            }

            @Override
            public void when() {
                TestCase.assertTrue((boolean)RejectRecordTest.this.recordService.isRecord(RejectRecordTest.this.dmDocument));
                TestCase.assertTrue((boolean)RejectRecordTest.this.permissionService.getInheritParentPermissions(RejectRecordTest.this.dmDocument));
                RejectRecordTest.this.recordService.rejectRecord(RejectRecordTest.this.dmDocument, REASON);
            }

            @Override
            public void then() {
                TestCase.assertFalse((boolean)RejectRecordTest.this.recordService.isRecord(RejectRecordTest.this.dmDocument));
                TestCase.assertEquals((String)RejectRecordTest.this.userName, (String)RejectRecordTest.this.ownableService.getOwner(RejectRecordTest.this.dmDocument));
                TestCase.assertTrue((boolean)RejectRecordTest.this.permissionService.getInheritParentPermissions(RejectRecordTest.this.dmDocument));
                TestCase.assertFalse((boolean)RejectRecordTest.this.nodeService.hasAspect(RejectRecordTest.this.dmDocument, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT));
            }
        });
    }

    public void testRevertAfterReject() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef document;

            @Override
            public void given() {
                NodeRef folder = RejectRecordTest.this.fileFolderService.create(RejectRecordTest.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document = RejectRecordTest.this.fileFolderService.create(folder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                TestCase.assertFalse((boolean)RejectRecordTest.this.recordService.isRecord(this.document));
                RejectRecordTest.this.ownableService.setOwner(this.document, RejectRecordTest.this.userName);
                RejectRecordTest.this.versionService.ensureVersioningEnabled(this.document, null);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RejectRecordTest.this.recordService.createRecord(RejectRecordTest.this.filePlan, document);
                        return null;
                    }
                }, (String)RejectRecordTest.this.userName);
                TestCase.assertTrue((boolean)RejectRecordTest.this.nodeService.hasAspect(this.document, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT));
            }

            @Override
            public void when() {
                RejectRecordTest.this.recordService.rejectRecord(this.document, REASON);
                TestCase.assertFalse((boolean)RejectRecordTest.this.nodeService.hasAspect(this.document, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        ContentWriter writer = RejectRecordTest.this.contentService.getWriter(document, ContentModel.PROP_CONTENT, true);
                        writer.putContent("This is a change to the content and should force a new version");
                        RejectRecordTest.this.versionService.createVersion(document, null);
                        return null;
                    }
                }, (String)RejectRecordTest.this.userName);
                TestCase.assertFalse((boolean)RejectRecordTest.this.nodeService.hasAspect(this.document, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT));
                VersionHistory history = RejectRecordTest.this.versionService.getVersionHistory(this.document);
                TestCase.assertEquals((int)2, (int)history.getAllVersions().size());
                final Version initial = history.getRootVersion();
                TestCase.assertFalse((boolean)RejectRecordTest.this.nodeService.hasAspect(initial.getFrozenStateNodeRef(), RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RejectRecordTest.this.versionService.revert(document, initial);
                        return null;
                    }
                }, (String)RejectRecordTest.this.userName);
            }

            @Override
            public void then() {
                TestCase.assertFalse((boolean)RejectRecordTest.this.recordService.isRecord(this.document));
                TestCase.assertEquals((String)RejectRecordTest.this.userName, (String)RejectRecordTest.this.ownableService.getOwner(this.document));
            }
        });
    }

    public void testRelationshipAfterRevertingRecord() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef document;

            @Override
            public void given() {
                NodeRef folder = RejectRecordTest.this.fileFolderService.create(RejectRecordTest.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.document = RejectRecordTest.this.fileFolderService.create(folder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                PropertyMap recordableVersionProperties = new PropertyMap(2);
                recordableVersionProperties.put((Object)RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY, (Object)RecordableVersionPolicy.ALL);
                recordableVersionProperties.put((Object)RecordableVersionModel.PROP_FILE_PLAN, (Object)RejectRecordTest.this.filePlan);
                RejectRecordTest.this.nodeService.addAspect(this.document, ContentModel.ASPECT_VERSIONABLE, (Map)recordableVersionProperties);
                this.document = RejectRecordTest.this.checkOutCheckInService.checkout(this.document);
                HashMap<String, String> props = new HashMap<String, String>(2);
                props.put("description", GUID.generate());
                props.put("versionType", (String)VersionType.MINOR);
                this.document = RejectRecordTest.this.checkOutCheckInService.checkin(this.document, props);
                List childAssocs = RejectRecordTest.this.nodeService.getChildAssocs(RejectRecordTest.this.unfiledContainer);
                TestCase.assertEquals((int)1, (int)childAssocs.size());
                RejectRecordTest.this.recordService.createRecord(RejectRecordTest.this.filePlan, this.document);
                childAssocs = RejectRecordTest.this.nodeService.getChildAssocs(RejectRecordTest.this.unfiledContainer);
                TestCase.assertEquals((int)2, (int)childAssocs.size());
                TestCase.assertTrue((boolean)RejectRecordTest.this.nodeService.hasAspect(this.document, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT));
                NodeRef finalVersion = null;
                for (ChildAssociationRef childAssociationRef : RejectRecordTest.this.nodeService.getChildAssocs(RejectRecordTest.this.unfiledContainer)) {
                    NodeRef childRef = childAssociationRef.getChildRef();
                    String label = (String)((Object)RejectRecordTest.this.nodeService.getProperty(this.document, RecordableVersionModel.PROP_VERSION_LABEL));
                    if (!label.equals(I18NUtil.getMessage((String)RejectRecordTest.FINAL_VERSION))) continue;
                    finalVersion = childRef;
                    break;
                }
                TestCase.assertEquals((Object)this.document, finalVersion);
                Set relationships = RejectRecordTest.this.relationshipService.getRelationshipsFrom(this.document);
                TestCase.assertEquals((int)1, (int)relationships.size());
                Relationship relationship = (Relationship)relationships.iterator().next();
                TestCase.assertEquals((String)RecordsManagementCustomModel.CUSTOM_REF_VERSIONS.getLocalName(), (String)relationship.getUniqueName());
            }

            @Override
            public void when() {
                RejectRecordTest.this.recordService.rejectRecord(this.document, GUID.generate());
            }

            @Override
            public void then() {
                Set relationships = RejectRecordTest.this.relationshipService.getRelationshipsFrom(this.document);
                TestCase.assertEquals((int)0, (int)relationships.size());
            }
        });
    }
}

