/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.version;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.integration.version.RecordableVersionsBaseTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.version.ExtendedVersionableAspect;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class AutoVersionTest
extends RecordableVersionsBaseTest {
    public void testSpecialisedNodeInitialVersionCreated() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private NodeRef myDocument;

            @Override
            public void given() throws Exception {
                this.myDocument = AutoVersionTest.this.fileFolderService.create(AutoVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                AutoVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, null);
            }

            @Override
            public void when() {
                AutoVersionTest.this.nodeService.setType(this.myDocument, AutoVersionTest.this.TYPE_CUSTOM_TYPE);
            }

            @Override
            public void then() {
                VersionHistory versionHistory = AutoVersionTest.this.versionService.getVersionHistory(this.myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                TestCase.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                NodeRef frozenState = versionHistory.getHeadVersion().getFrozenStateNodeRef();
                TestCase.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)AutoVersionTest.this.nodeService.getType(frozenState));
                TestCase.assertEquals((Object)AutoVersionTest.this.TYPE_CUSTOM_TYPE, (Object)AutoVersionTest.this.nodeService.getType(this.myDocument));
            }
        });
    }

    public void testSpecialisedNodeInitialVersionNotCreated() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private NodeRef myDocument;

            @Override
            public void given() throws Exception {
                this.myDocument = AutoVersionTest.this.fileFolderService.create(AutoVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                HashMap<QName, Boolean> props = new HashMap<QName, Boolean>(1);
                props.put(ContentModel.PROP_INITIAL_VERSION, false);
                AutoVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, props);
            }

            @Override
            public void when() {
                AutoVersionTest.this.nodeService.setType(this.myDocument, AutoVersionTest.this.TYPE_CUSTOM_TYPE);
            }

            @Override
            public void then() {
                VersionHistory versionHistory = AutoVersionTest.this.versionService.getVersionHistory(this.myDocument);
                TestCase.assertNull((Object)versionHistory);
            }
        });
    }

    public void testSpecialisedNodeInitialVersionNotCreatedOnTypeChangeOn() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private ExtendedVersionableAspect extendedVersionableAspect;
            private NodeRef myDocument;

            @Override
            public void given() throws Exception {
                this.extendedVersionableAspect = (ExtendedVersionableAspect)AutoVersionTest.this.applicationContext.getBean("rm.extendedVersionableAspect");
                TestCase.assertNotNull((Object)this.extendedVersionableAspect);
                this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
                this.myDocument = AutoVersionTest.this.fileFolderService.create(AutoVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                HashMap<QName, Boolean> props = new HashMap<QName, Boolean>(1);
                props.put(ContentModel.PROP_INITIAL_VERSION, false);
                AutoVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, props);
            }

            @Override
            public void when() {
                AutoVersionTest.this.nodeService.setType(this.myDocument, AutoVersionTest.this.TYPE_CUSTOM_TYPE);
            }

            @Override
            public void then() {
                VersionHistory versionHistory = AutoVersionTest.this.versionService.getVersionHistory(this.myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                TestCase.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                NodeRef frozenState = versionHistory.getHeadVersion().getFrozenStateNodeRef();
                TestCase.assertEquals((Object)AutoVersionTest.this.TYPE_CUSTOM_TYPE, (Object)AutoVersionTest.this.nodeService.getType(frozenState));
                TestCase.assertEquals((Object)AutoVersionTest.this.TYPE_CUSTOM_TYPE, (Object)AutoVersionTest.this.nodeService.getType(this.myDocument));
            }

            @Override
            public void after() throws Exception {
                this.extendedVersionableAspect.setAutoVersionOnTypeChange(false);
            }
        });
    }

    public void testSpecialisedNodeInitialVersionCreatedOnTypeChangeOn() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private ExtendedVersionableAspect extendedVersionableAspect;
            private NodeRef myDocument;

            @Override
            public void given() throws Exception {
                this.extendedVersionableAspect = (ExtendedVersionableAspect)AutoVersionTest.this.applicationContext.getBean("rm.extendedVersionableAspect");
                TestCase.assertNotNull((Object)this.extendedVersionableAspect);
                this.extendedVersionableAspect.setAutoVersionOnTypeChange(true);
                this.myDocument = AutoVersionTest.this.fileFolderService.create(AutoVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                HashMap<QName, Boolean> props = new HashMap<QName, Boolean>(1);
                props.put(ContentModel.PROP_INITIAL_VERSION, true);
                AutoVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, props);
            }

            @Override
            public void when() {
                AutoVersionTest.this.nodeService.setType(this.myDocument, AutoVersionTest.this.TYPE_CUSTOM_TYPE);
            }

            @Override
            public void then() {
                VersionHistory versionHistory = AutoVersionTest.this.versionService.getVersionHistory(this.myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                TestCase.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                NodeRef frozenState = versionHistory.getHeadVersion().getFrozenStateNodeRef();
                TestCase.assertEquals((Object)AutoVersionTest.this.TYPE_CUSTOM_TYPE, (Object)AutoVersionTest.this.nodeService.getType(frozenState));
                TestCase.assertEquals((Object)AutoVersionTest.this.TYPE_CUSTOM_TYPE, (Object)AutoVersionTest.this.nodeService.getType(this.myDocument));
                frozenState = versionHistory.getVersion("1.0").getFrozenStateNodeRef();
                TestCase.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)AutoVersionTest.this.nodeService.getType(frozenState));
                TestCase.assertEquals((Object)AutoVersionTest.this.TYPE_CUSTOM_TYPE, (Object)AutoVersionTest.this.nodeService.getType(this.myDocument));
            }

            @Override
            public void after() throws Exception {
                this.extendedVersionableAspect.setAutoVersionOnTypeChange(false);
            }
        });
    }
}

