/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RecordServiceImplTest
extends BaseRMTestCase
implements RecordsManagementPolicies.BeforeRecordDeclaration,
RecordsManagementPolicies.OnRecordDeclaration,
RecordsManagementPolicies.BeforeRecordRejection,
RecordsManagementPolicies.OnRecordRejection {
    private boolean beforeRecordDeclaration = false;
    private boolean onRecordDeclaration = false;
    private boolean beforeRecordRejection = false;
    private boolean onRecordRejection = false;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testGetRecordMetaDataAspects() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Set aspects = RecordServiceImplTest.this.recordService.getRecordMetadataAspects(RecordServiceImplTest.this.filePlan);
                TestCase.assertNotNull((Object)aspects);
                TestCase.assertEquals((int)2, (int)aspects.size());
                TestCase.assertTrue((boolean)aspects.containsAll(this.getAspectList()));
                return null;
            }

            private List<QName> getAspectList() {
                QName[] aspects = new QName[]{RecordServiceImplTest.this.ASPECT_RECORD_META_DATA};
                return Arrays.asList(aspects);
            }
        });
    }

    public void testIsRecord() throws Exception {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() {
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.recordOne));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.recordDeclaredOne));
            }
        });
    }

    public void testIsDeclared() throws Exception {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() {
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.recordOne));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.recordDeclaredOne));
            }
        });
    }

    public void testUnfiled() throws Exception {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() {
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.recordOne));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.recordDeclaredOne));
            }
        });
    }

    public void testExtendedWriters() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.extendedSecurityService.getReaders(RecordServiceImplTest.this.recordOne).isEmpty());
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.extendedSecurityService.getWriters(RecordServiceImplTest.this.recordOne).isEmpty());
                return null;
            }
        }, this.dmCollaborator);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.recordOne, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.recordOne, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "EditNonRecordMetadata"));
                return null;
            }
        }, this.dmCollaborator);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                HashSet<String> writers = new HashSet<String>(1);
                writers.add(RecordServiceImplTest.this.dmCollaborator);
                RecordServiceImplTest.this.extendedSecurityService.set(RecordServiceImplTest.this.recordOne, null, writers);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.extendedSecurityService.getReaders(RecordServiceImplTest.this.recordOne).isEmpty());
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.extendedSecurityService.getWriters(RecordServiceImplTest.this.recordOne).isEmpty());
                return null;
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.recordOne, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.recordOne, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "EditNonRecordMetadata"));
                return null;
            }
        }, this.dmCollaborator);
    }

    public void testCreateRecord() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Can not create a record from a document if you do not have WRITE permissions.", AccessDeniedException.class){

            public void run() throws Exception {
                RecordServiceImplTest.this.recordService.createRecord(RecordServiceImplTest.this.filePlan, RecordServiceImplTest.this.dmDocument);
            }
        }, this.dmConsumer);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){
            private NodeRef originalLocation;

            public Void run() {
                this.originalLocation = RecordServiceImplTest.this.nodeService.getPrimaryParent(RecordServiceImplTest.this.dmDocument).getParentRef();
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(RecordServiceImplTest.this.dmDocument));
                RecordServiceImplTest.this.checkPermissions("ReadRecords", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                RecordServiceImplTest.this.checkPermissions("Filing", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
                RecordServiceImplTest.this.recordService.createRecord(RecordServiceImplTest.this.filePlan, RecordServiceImplTest.this.dmDocument);
                return null;
            }

            public void test(Void result) {
                RecordServiceImplTest.this.checkPermissions("ReadRecords", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                RecordServiceImplTest.this.checkPermissions("Filing", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(RecordServiceImplTest.this.dmDocument));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.dmDocument));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.nodeService.hasAspect(RecordServiceImplTest.this.dmDocument, RecordsManagementModel.ASPECT_RECORD_ORIGINATING_DETAILS));
                TestCase.assertEquals((Object)this.originalLocation, (Object)RecordServiceImplTest.this.nodeService.getProperty(RecordServiceImplTest.this.dmDocument, RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION));
                TestCase.assertFalse((this.originalLocation == RecordServiceImplTest.this.nodeService.getPrimaryParent(RecordServiceImplTest.this.dmDocument).getParentRef() ? 1 : 0) != 0);
                TestCase.assertEquals((int)2, (int)RecordServiceImplTest.this.nodeService.getParentAssocs(RecordServiceImplTest.this.dmDocument).size());
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "EditNonRecordMetadata"));
                Capability filling = RecordServiceImplTest.this.capabilityService.getCapability("FileRecords");
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)filling.hasPermission(RecordServiceImplTest.this.dmDocument));
                Capability editRecordMetadata = RecordServiceImplTest.this.capabilityService.getCapability("EditNonRecordMetadata");
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)editRecordMetadata.hasPermission(RecordServiceImplTest.this.dmDocument));
                Capability updateProperties = RecordServiceImplTest.this.capabilityService.getCapability("UpdateProperties");
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)updateProperties.hasPermission(RecordServiceImplTest.this.dmDocument));
            }
        }, this.dmCollaborator);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RecordServiceImplTest.this.checkPermissions("ReadRecords", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED);
                RecordServiceImplTest.this.checkPermissions("Filing", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "EditNonRecordMetadata"));
                Capability filling = RecordServiceImplTest.this.capabilityService.getCapability("FileRecords");
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)filling.hasPermission(RecordServiceImplTest.this.dmDocument));
                Capability editRecordMetadata = RecordServiceImplTest.this.capabilityService.getCapability("EditNonRecordMetadata");
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)editRecordMetadata.hasPermission(RecordServiceImplTest.this.dmDocument));
                Capability updateProperties = RecordServiceImplTest.this.capabilityService.getCapability("UpdateProperties");
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)updateProperties.hasPermission(RecordServiceImplTest.this.dmDocument));
                return null;
            }
        }, this.dmConsumer);
    }

    public void testCreateRecordNoLink() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Can not create a record from a document if you do not have WRITE permissions.", AccessDeniedException.class){

            public void run() throws Exception {
                RecordServiceImplTest.this.recordService.createRecord(RecordServiceImplTest.this.filePlan, RecordServiceImplTest.this.dmDocument, false);
            }
        }, this.dmConsumer);
        final NodeRef originalLocation = (NodeRef)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef originalLocation = RecordServiceImplTest.this.nodeService.getPrimaryParent(RecordServiceImplTest.this.dmDocument).getParentRef();
                RecordServiceImplTest.this.checkPermissions("ReadRecords", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                RecordServiceImplTest.this.checkPermissions("Filing", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
                RecordServiceImplTest.this.recordService.createRecord(RecordServiceImplTest.this.filePlan, RecordServiceImplTest.this.dmDocument, false);
                RecordServiceImplTest.this.checkPermissions("ReadRecords", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.filePlan, "ViewRecords"));
                RecordServiceImplTest.this.checkPermissions("Filing", AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
                return originalLocation;
            }
        }, this.dmCollaborator);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(RecordServiceImplTest.this.dmDocument));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.dmDocument));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.nodeService.hasAspect(RecordServiceImplTest.this.dmDocument, RecordsManagementModel.ASPECT_RECORD_ORIGINATING_DETAILS));
                TestCase.assertEquals((Object)originalLocation, (Object)RecordServiceImplTest.this.nodeService.getProperty(RecordServiceImplTest.this.dmDocument, RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION));
                TestCase.assertFalse((originalLocation == RecordServiceImplTest.this.nodeService.getPrimaryParent(RecordServiceImplTest.this.dmDocument).getParentRef() ? 1 : 0) != 0);
                TestCase.assertEquals((int)1, (int)RecordServiceImplTest.this.nodeService.getParentAssocs(RecordServiceImplTest.this.dmDocument).size());
                return null;
            }
        }, "admin");
    }

    public void testFileNewContent() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef record = RecordServiceImplTest.this.fileFolderService.create(RecordServiceImplTest.this.rmFolder, "test101.txt", ContentModel.TYPE_CONTENT).getNodeRef();
                ContentWriter writer = RecordServiceImplTest.this.contentService.getWriter(record, ContentModel.PROP_CONTENT, true);
                writer.setEncoding("UTF-8");
                writer.setMimetype("text/plain");
                writer.putContent("hello world this is some test content");
                return record;
            }

            public void test(NodeRef record) throws Exception {
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(record));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isFiled(record));
                TestCase.assertNotNull((Object)RecordServiceImplTest.this.nodeService.getProperty(record, RecordsManagementModel.PROP_DATE_FILED));
            }
        });
    }

    public void xtestFileUnfiledrecord() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                RecordServiceImplTest.this.recordService.createRecord(RecordServiceImplTest.this.filePlan, RecordServiceImplTest.this.dmDocument);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isFiled(RecordServiceImplTest.this.dmDocument));
                TestCase.assertNull((Object)RecordServiceImplTest.this.nodeService.getProperty(RecordServiceImplTest.this.dmDocument, RecordsManagementModel.PROP_DATE_FILED));
                RecordServiceImplTest.this.fileFolderService.move(RecordServiceImplTest.this.dmDocument, RecordServiceImplTest.this.rmFolder, "record.txt");
                return RecordServiceImplTest.this.dmDocument;
            }

            public void test(NodeRef record) throws Exception {
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(record));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isFiled(record));
                TestCase.assertNotNull((Object)RecordServiceImplTest.this.nodeService.getProperty(record, RecordsManagementModel.PROP_DATE_FILED));
            }
        });
    }

    public void testFileDirectlyFromCollab() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                TestCase.assertNull((Object)RecordServiceImplTest.this.nodeService.getProperty(RecordServiceImplTest.this.dmDocument, RecordsManagementModel.PROP_DATE_FILED));
                RecordServiceImplTest.this.fileFolderService.move(RecordServiceImplTest.this.dmDocument, RecordServiceImplTest.this.rmFolder, "record.txt");
                return RecordServiceImplTest.this.dmDocument;
            }

            public void test(NodeRef record) throws Exception {
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(record));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isFiled(record));
                TestCase.assertNotNull((Object)RecordServiceImplTest.this.nodeService.getProperty(record, RecordsManagementModel.PROP_DATE_FILED));
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    private void checkPermissions(String permission, AccessStatus filePlanExpected, AccessStatus unfiledExpected, AccessStatus recordCatExpected, AccessStatus recordFolderExpected, AccessStatus recordExpected) {
        RecordServiceImplTest.assertEquals((Object)filePlanExpected, (Object)this.permissionService.hasPermission(this.filePlan, permission));
        RecordServiceImplTest.assertEquals((Object)unfiledExpected, (Object)this.permissionService.hasPermission(this.unfiledContainer, permission));
        RecordServiceImplTest.assertEquals((Object)recordCatExpected, (Object)this.permissionService.hasPermission(this.rmContainer, permission));
        RecordServiceImplTest.assertEquals((Object)recordFolderExpected, (Object)this.permissionService.hasPermission(this.rmFolder, permission));
        RecordServiceImplTest.assertEquals((Object)recordExpected, (Object)this.permissionService.hasPermission(this.dmDocument, permission));
    }

    private String createUserWithCapabilties(final String ... capabiltyNames) {
        return (String)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<String>(){

            public String run() throws Exception {
                Role role = RecordServiceImplTest.this.utils.createRole(RecordServiceImplTest.this.filePlan, GUID.generate(), capabiltyNames);
                String userName = GUID.generate();
                RecordServiceImplTest.this.createPerson(userName);
                RecordServiceImplTest.this.filePlanRoleService.assignRoleToAuthority(RecordServiceImplTest.this.filePlan, role.getName(), userName);
                return userName;
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    public void testIsPropertyEditable() throws Exception {
        final String nonRecordMetadata = this.createUserWithCapabilties("ViewRecords", "EditNonRecordMetadata");
        final String recordMetadata = this.createUserWithCapabilties("ViewRecords", "EditRecordMetadata");
        final String declaredRecordMetadata = this.createUserWithCapabilties("ViewRecords", "EditDeclaredRecordMetadata");
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, RecordServiceImplTest.this.rmUserName, "Filing");
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, nonRecordMetadata, "Filing");
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, recordMetadata, "Filing");
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, declaredRecordMetadata, "Filing");
            }
        });
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, ContentModel.PROP_DESCRIPTION));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION));
            }
        });
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RecordServiceImplTest.this.permissionService.hasPermission(RecordServiceImplTest.this.recordOne, "ReadRecords"));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, ContentModel.PROP_DESCRIPTION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION));
            }
        }, this.rmUserName);
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, ContentModel.PROP_DESCRIPTION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION));
            }
        }, nonRecordMetadata);
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, ContentModel.PROP_DESCRIPTION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION));
            }
        }, recordMetadata);
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordOne, ContentModel.PROP_DESCRIPTION));
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isPropertyEditable(RecordServiceImplTest.this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION));
            }
        }, declaredRecordMetadata);
    }

    public void testRecordPropertiesUpdate() throws Exception {
        final String nonRecordMetadata = this.createUserWithCapabilties("ViewRecords", "EditNonRecordMetadata");
        final String recordMetadata = this.createUserWithCapabilties("ViewRecords", "EditRecordMetadata");
        final String declaredRecordMetadata = this.createUserWithCapabilties("ViewRecords", "EditDeclaredRecordMetadata");
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, RecordServiceImplTest.this.rmUserName, "Filing");
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, nonRecordMetadata, "Filing");
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, recordMetadata, "Filing");
                RecordServiceImplTest.this.filePlanPermissionService.setPermission(RecordServiceImplTest.this.rmFolder, declaredRecordMetadata, "Filing");
            }
        });
        this.canEditProperty(this.recordOne, ContentModel.PROP_DESCRIPTION, "admin");
        this.canEditProperty(this.recordOne, RecordsManagementModel.PROP_LOCATION, "admin");
        this.cantEditProperty(this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION, "admin");
        this.canEditProperty(this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION, "admin");
        this.cantEditProperty(this.recordOne, ContentModel.PROP_DESCRIPTION, this.rmUserName);
        this.cantEditProperty(this.recordOne, RecordsManagementModel.PROP_LOCATION, this.rmUserName);
        this.cantEditProperty(this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION, this.rmUserName);
        this.cantEditProperty(this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION, this.rmUserName);
        this.canEditProperty(this.recordOne, ContentModel.PROP_DESCRIPTION, nonRecordMetadata);
        this.cantEditProperty(this.recordOne, RecordsManagementModel.PROP_LOCATION, nonRecordMetadata);
        this.cantEditProperty(this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION, nonRecordMetadata);
        this.cantEditProperty(this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION, nonRecordMetadata);
        this.cantEditProperty(this.recordOne, ContentModel.PROP_DESCRIPTION, recordMetadata);
        this.canEditProperty(this.recordOne, RecordsManagementModel.PROP_LOCATION, recordMetadata);
        this.cantEditProperty(this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION, recordMetadata);
        this.cantEditProperty(this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION, recordMetadata);
        this.cantEditProperty(this.recordOne, ContentModel.PROP_DESCRIPTION, declaredRecordMetadata);
        this.cantEditProperty(this.recordOne, RecordsManagementModel.PROP_LOCATION, declaredRecordMetadata);
        this.cantEditProperty(this.recordDeclaredOne, ContentModel.PROP_DESCRIPTION, declaredRecordMetadata);
        this.canEditProperty(this.recordDeclaredOne, RecordsManagementModel.PROP_LOCATION, declaredRecordMetadata);
    }

    private void cantEditProperty(final NodeRef nodeRef, final QName property, String user) throws Exception {
        boolean failure = false;
        try {
            this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                @Override
                public void runImpl() throws Exception {
                    RecordServiceImplTest.this.nodeService.setProperty(nodeRef, property, (Serializable)((Object)GUID.generate()));
                }
            }, user);
        }
        catch (Throwable exception) {
            failure = true;
        }
        if (!failure) {
            RecordServiceImplTest.fail((String)"Property should not have been editable.");
        }
    }

    private void canEditProperty(final NodeRef nodeRef, final QName property, String user) throws Exception {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                RecordServiceImplTest.this.nodeService.setProperty(nodeRef, property, (Serializable)((Object)GUID.generate()));
            }
        }, user);
    }

    public void testPolicyNotificationForRecordDeclaration() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                BehaviourDefinition beforeRecordDeclarationBehaviour = RecordServiceImplTest.this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.BEFORE_RECORD_DECLARATION, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour((Object)RecordServiceImplTest.this, "beforeRecordDeclaration", Behaviour.NotificationFrequency.EVERY_EVENT));
                BehaviourDefinition onRecordDeclarationBehaviour = RecordServiceImplTest.this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.ON_RECORD_DECLARATION, RecordsManagementModel.ASPECT_RECORD, (Behaviour)new JavaBehaviour((Object)RecordServiceImplTest.this, "onRecordDeclaration", Behaviour.NotificationFrequency.EVERY_EVENT));
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.beforeRecordDeclaration);
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.onRecordDeclaration);
                RecordServiceImplTest.this.recordService.createRecord(RecordServiceImplTest.this.filePlan, RecordServiceImplTest.this.dmDocument);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.beforeRecordDeclaration);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.onRecordDeclaration);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                RecordServiceImplTest.this.policyComponent.removeClassDefinition(beforeRecordDeclarationBehaviour);
                RecordServiceImplTest.this.policyComponent.removeClassDefinition(onRecordDeclarationBehaviour);
                return null;
            }
        }, this.dmCollaborator);
    }

    public void beforeRecordDeclaration(NodeRef nodeRef) {
        RecordServiceImplTest.assertEquals((Object)nodeRef, (Object)this.dmDocument);
        this.beforeRecordDeclaration = true;
    }

    public void onRecordDeclaration(NodeRef nodeRef) {
        RecordServiceImplTest.assertEquals((Object)nodeRef, (Object)this.dmDocument);
        this.onRecordDeclaration = true;
    }

    public void beforeRecordRejection(NodeRef nodeRef) {
        RecordServiceImplTest.assertEquals((Object)nodeRef, (Object)this.dmDocument);
        this.beforeRecordRejection = true;
    }

    public void onRecordRejection(NodeRef nodeRef) {
        RecordServiceImplTest.assertEquals((Object)nodeRef, (Object)this.dmDocument);
        this.onRecordRejection = true;
    }

    public void testPolicyNotificationForRecordRejection() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                BehaviourDefinition beforeRecordRejectionBehaviour = RecordServiceImplTest.this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.BEFORE_RECORD_REJECTION, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour((Object)RecordServiceImplTest.this, "beforeRecordRejection", Behaviour.NotificationFrequency.EVERY_EVENT));
                BehaviourDefinition onRecordRejectionBehaviour = RecordServiceImplTest.this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.ON_RECORD_REJECTION, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour((Object)RecordServiceImplTest.this, "onRecordRejection", Behaviour.NotificationFrequency.EVERY_EVENT));
                RecordServiceImplTest.this.recordService.createRecord(RecordServiceImplTest.this.filePlan, RecordServiceImplTest.this.dmDocument);
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.beforeRecordRejection);
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.onRecordRejection);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                RecordServiceImplTest.this.recordService.rejectRecord(RecordServiceImplTest.this.dmDocument, "test reasons");
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.beforeRecordRejection);
                TestCase.assertTrue((boolean)RecordServiceImplTest.this.onRecordRejection);
                TestCase.assertFalse((boolean)RecordServiceImplTest.this.recordService.isRecord(RecordServiceImplTest.this.dmDocument));
                RecordServiceImplTest.this.policyComponent.removeClassDefinition(beforeRecordRejectionBehaviour);
                RecordServiceImplTest.this.policyComponent.removeClassDefinition(onRecordRejectionBehaviour);
                return null;
            }
        }, this.dmCollaborator);
    }
}

