/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.alfresco.util.GUID;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class EventRestApiTest
extends BaseRMWebScriptTestCase
implements RecordsManagementModel {
    protected static final String GET_EVENTS_URL = "/api/rma/admin/rmevents";
    protected static final String GET_EVENTTYPES_URL = "/api/rma/admin/rmeventtypes";
    protected static final String SERVICE_URL_PREFIX = "/alfresco/service";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String DISPLAY_LABEL = "display label";
    protected static final String EVENT_TYPE = "rmEventType.simple";
    protected static final String KEY_EVENT_NAME = "eventName";
    protected static final String KEY_EVENT_TYPE = "eventType";
    protected static final String KEY_EVENT_DISPLAY_LABEL = "eventDisplayLabel";

    public void testGetEventTypes() throws Exception {
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(GET_EVENTTYPES_URL), 200);
        String rspContent = rsp.getContentAsString();
        JSONObject obj = new JSONObject(rspContent);
        JSONObject types = obj.getJSONObject("data");
        EventRestApiTest.assertNotNull((Object)types);
        JSONObject type = types.getJSONObject(EVENT_TYPE);
        EventRestApiTest.assertNotNull((Object)type);
        EventRestApiTest.assertEquals((String)EVENT_TYPE, (String)type.getString("eventTypeName"));
        EventRestApiTest.assertNotNull((Object)type.getString("eventTypeDisplayLabel"));
        System.out.println(rspContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEvents() throws Exception {
        String event1 = GUID.generate();
        String event2 = GUID.generate();
        this.eventService.addEvent(EVENT_TYPE, event1, DISPLAY_LABEL);
        this.eventService.addEvent(EVENT_TYPE, event2, DISPLAY_LABEL);
        try {
            TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(GET_EVENTS_URL), 200);
            String rspContent = rsp.getContentAsString();
            JSONObject obj = new JSONObject(rspContent);
            JSONObject roles = obj.getJSONObject("data");
            EventRestApiTest.assertNotNull((Object)roles);
            JSONObject eventObj = roles.getJSONObject(event1);
            EventRestApiTest.assertNotNull((Object)eventObj);
            EventRestApiTest.assertEquals((Object)event1, (Object)eventObj.get(KEY_EVENT_NAME));
            EventRestApiTest.assertEquals((Object)DISPLAY_LABEL, (Object)eventObj.get(KEY_EVENT_DISPLAY_LABEL));
            EventRestApiTest.assertEquals((Object)EVENT_TYPE, (Object)eventObj.get(KEY_EVENT_TYPE));
            eventObj = roles.getJSONObject(event2);
            EventRestApiTest.assertNotNull((Object)eventObj);
            EventRestApiTest.assertEquals((Object)event2, (Object)eventObj.get(KEY_EVENT_NAME));
            EventRestApiTest.assertEquals((Object)DISPLAY_LABEL, (Object)eventObj.get(KEY_EVENT_DISPLAY_LABEL));
            EventRestApiTest.assertEquals((Object)EVENT_TYPE, (Object)eventObj.get(KEY_EVENT_TYPE));
        }
        finally {
            this.eventService.removeEvent(event1);
            this.eventService.removeEvent(event2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPostEvents() throws Exception {
        JSONObject eventObj;
        JSONObject resultObj;
        String rspContent;
        String eventName = GUID.generate();
        JSONObject obj = new JSONObject();
        obj.put(KEY_EVENT_NAME, (Object)eventName);
        obj.put(KEY_EVENT_DISPLAY_LABEL, (Object)DISPLAY_LABEL);
        obj.put(KEY_EVENT_TYPE, (Object)EVENT_TYPE);
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(GET_EVENTS_URL, obj.toString(), APPLICATION_JSON), 200);
        try {
            rspContent = rsp.getContentAsString();
            resultObj = new JSONObject(rspContent);
            eventObj = resultObj.getJSONObject("data");
            EventRestApiTest.assertNotNull((Object)eventObj);
            EventRestApiTest.assertEquals((Object)eventName, (Object)eventObj.get(KEY_EVENT_NAME));
            EventRestApiTest.assertEquals((Object)DISPLAY_LABEL, (Object)eventObj.get(KEY_EVENT_DISPLAY_LABEL));
            EventRestApiTest.assertEquals((Object)EVENT_TYPE, (Object)eventObj.get(KEY_EVENT_TYPE));
        }
        finally {
            this.eventService.removeEvent(eventName);
        }
        obj = new JSONObject();
        obj.put(KEY_EVENT_DISPLAY_LABEL, (Object)DISPLAY_LABEL);
        obj.put(KEY_EVENT_TYPE, (Object)EVENT_TYPE);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(GET_EVENTS_URL, obj.toString(), APPLICATION_JSON), 200);
        try {
            rspContent = rsp.getContentAsString();
            resultObj = new JSONObject(rspContent);
            eventObj = resultObj.getJSONObject("data");
            EventRestApiTest.assertNotNull((Object)eventObj);
            EventRestApiTest.assertNotNull((Object)eventObj.get(KEY_EVENT_NAME));
            EventRestApiTest.assertEquals((Object)DISPLAY_LABEL, (Object)eventObj.get(KEY_EVENT_DISPLAY_LABEL));
            EventRestApiTest.assertEquals((Object)EVENT_TYPE, (Object)eventObj.get(KEY_EVENT_TYPE));
            eventName = eventObj.getString(KEY_EVENT_NAME);
        }
        finally {
            this.eventService.removeEvent(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutRole() throws Exception {
        String eventName = GUID.generate();
        this.eventService.addEvent(EVENT_TYPE, eventName, DISPLAY_LABEL);
        try {
            JSONObject obj = new JSONObject();
            obj.put(KEY_EVENT_NAME, (Object)eventName);
            obj.put(KEY_EVENT_DISPLAY_LABEL, (Object)"changed");
            obj.put(KEY_EVENT_TYPE, (Object)EVENT_TYPE);
            TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/rma/admin/rmevents/" + eventName, obj.toString(), APPLICATION_JSON), 200);
            String rspContent = rsp.getContentAsString();
            JSONObject result = new JSONObject(rspContent);
            JSONObject eventObj = result.getJSONObject("data");
            EventRestApiTest.assertNotNull((Object)eventObj);
            EventRestApiTest.assertEquals((Object)eventName, (Object)eventObj.get(KEY_EVENT_NAME));
            EventRestApiTest.assertEquals((Object)"changed", (Object)eventObj.get(KEY_EVENT_DISPLAY_LABEL));
            EventRestApiTest.assertEquals((Object)EVENT_TYPE, (Object)eventObj.get(KEY_EVENT_TYPE));
            obj = new JSONObject();
            obj.put(KEY_EVENT_NAME, (Object)"cheese");
            obj.put(KEY_EVENT_DISPLAY_LABEL, (Object)"whatever");
            obj.put(KEY_EVENT_TYPE, (Object)EVENT_TYPE);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/rma/admin/rmevents/cheese", obj.toString(), APPLICATION_JSON), 404);
        }
        finally {
            this.eventService.removeEvent(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRole() throws Exception {
        String eventName = GUID.generate();
        this.eventService.addEvent(EVENT_TYPE, eventName, DISPLAY_LABEL);
        try {
            TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/admin/rmevents/" + eventName), 200);
            String rspContent = rsp.getContentAsString();
            JSONObject obj = new JSONObject(rspContent);
            JSONObject eventObj = obj.getJSONObject("data");
            EventRestApiTest.assertNotNull((Object)eventObj);
            EventRestApiTest.assertEquals((Object)eventName, (Object)eventObj.get(KEY_EVENT_NAME));
            EventRestApiTest.assertEquals((Object)DISPLAY_LABEL, (Object)eventObj.get(KEY_EVENT_DISPLAY_LABEL));
            EventRestApiTest.assertEquals((Object)EVENT_TYPE, (Object)eventObj.get(KEY_EVENT_TYPE));
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/admin/rmevents/cheese"), 404);
        }
        finally {
            this.eventService.removeEvent(eventName);
        }
    }

    public void testDeleteRole() throws Exception {
        String eventName = GUID.generate();
        EventRestApiTest.assertFalse((boolean)this.eventService.existsEvent(eventName));
        this.eventService.addEvent(EVENT_TYPE, eventName, DISPLAY_LABEL);
        EventRestApiTest.assertTrue((boolean)this.eventService.existsEvent(eventName));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rma/admin/rmevents/" + eventName), 200);
        EventRestApiTest.assertFalse((boolean)this.eventService.existsEvent(eventName));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rma/admin/rmevents/cheese"), 404);
    }
}

