/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchParameters;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetailsCompatibility;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceService;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RMSavedSearchesPost
extends DeclarativeWebScript {
    protected RecordsManagementSearchService recordsManagementSearchService;
    protected SiteService siteService;
    protected NamespaceService namespaceService;

    public void setRecordsManagementSearchService(RecordsManagementSearchService recordsManagementSearchService) {
        this.recordsManagementSearchService = recordsManagementSearchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String siteId = (String)templateVars.get("site");
        if (siteId == null || siteId.length() == 0) {
            throw new WebScriptException(400, "Site id not provided.");
        }
        if (this.siteService.getSite(siteId) == null) {
            throw new WebScriptException(404, "Site not found.");
        }
        try {
            String search;
            JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            if (!json.has("name")) {
                throw new WebScriptException(400, "Mandatory 'name' parameter was not provided in request body");
            }
            String name = json.getString("name");
            String description = null;
            if (json.has("description")) {
                description = json.getString("description");
            }
            boolean isPublic = true;
            if (json.has("public")) {
                isPublic = json.getBoolean("public");
            }
            if (!json.has("params")) {
                throw new WebScriptException(400, "Mandatory 'params' parameter was not provided in request body");
            }
            String params = json.getString("params");
            String sort = null;
            if (json.has("sort")) {
                sort = json.getString("sort");
            }
            if ((search = SavedSearchDetailsCompatibility.getSearchFromParams(params)) == null) {
                throw new WebScriptException(400, "Mandatory 'terms' was not provided in 'params' parameter found in the request body");
            }
            RecordsManagementSearchParameters searchParameters = SavedSearchDetailsCompatibility.createSearchParameters(params, sort, this.namespaceService);
            this.recordsManagementSearchService.saveSearch(siteId, name, description, search, searchParameters, isPublic);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("success", true);
        return model;
    }
}

