/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition;

import org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition.FrozenCapabilityCondition;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FrozenCapabilityConditionUnitTest
extends BaseUnitTest {
    @InjectMocks
    private FrozenCapabilityCondition condition;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
    }

    @Test
    public void evaluateHold() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedHoldService.isHold(nodeRef)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.condition.evaluate(nodeRef));
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).isHold(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.never())).isFrozen(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.never())).hasFrozenChildren(nodeRef);
    }

    @Test
    public void frozenDontCheckChildren() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedHoldService.isHold(nodeRef)).thenReturn((Object)false);
        this.condition.setCheckChildren(false);
        Mockito.when((Object)this.mockedFreezeService.isFrozen(nodeRef)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.condition.evaluate(nodeRef));
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).isHold(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.times((int)1))).isFrozen(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.never())).hasFrozenChildren(nodeRef);
    }

    @Test
    public void notFrozenDontCheckChildren() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedHoldService.isHold(nodeRef)).thenReturn((Object)false);
        this.condition.setCheckChildren(false);
        Mockito.when((Object)this.mockedFreezeService.isFrozen(nodeRef)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.condition.evaluate(nodeRef));
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).isHold(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.times((int)1))).isFrozen(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.never())).hasFrozenChildren(nodeRef);
    }

    @Test
    public void frozenCheckChildren() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedHoldService.isHold(nodeRef)).thenReturn((Object)false);
        this.condition.setCheckChildren(true);
        Mockito.when((Object)this.mockedFreezeService.isFrozen(nodeRef)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.condition.evaluate(nodeRef));
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).isHold(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.times((int)1))).isFrozen(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.never())).hasFrozenChildren(nodeRef);
    }

    @Test
    public void notFrozenCheckChildrenNotFrozen() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedHoldService.isHold(nodeRef)).thenReturn((Object)false);
        this.condition.setCheckChildren(true);
        Mockito.when((Object)this.mockedFreezeService.isFrozen(nodeRef)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedFreezeService.hasFrozenChildren(nodeRef)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.condition.evaluate(nodeRef));
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).isHold(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.times((int)1))).isFrozen(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.times((int)1))).hasFrozenChildren(nodeRef);
    }

    @Test
    public void notFrozenCheckChildrenFrozen() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedHoldService.isHold(nodeRef)).thenReturn((Object)false);
        this.condition.setCheckChildren(true);
        Mockito.when((Object)this.mockedFreezeService.isFrozen(nodeRef)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedFreezeService.hasFrozenChildren(nodeRef)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.condition.evaluate(nodeRef));
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).isHold(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.times((int)1))).isFrozen(nodeRef);
        ((FreezeService)Mockito.verify((Object)this.mockedFreezeService, (VerificationMode)Mockito.times((int)1))).hasFrozenChildren(nodeRef);
    }
}

