/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.MockAuthenticationUtilHelper;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.imap.ExtendedImapServiceImpl;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.extensions.webscripts.GUID;

public class ExtendedImapServiceImplUnitTest {
    @Mock
    private NodeService mockedNodeService;
    @Mock
    private BehaviourFilter mockedPolicyBehaviourFilter;
    @Mock
    private DictionaryService mockedDictionaryService;
    @Mock
    private AuthenticationUtil mockedAuthenticationUtil;
    @InjectMocks
    private ExtendedImapServiceImpl extendedImapServiceImpl;
    private NodeRef rmSite = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
    private final String RM_SITE_NAME = "RM";
    private NodeRef rmFilePlan = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
    private final String RM_FILEPLAN_NAME = "fileplan";
    private NodeRef rmCategory = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
    private final String RM_CATEGORY_NAME = "C1";

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        MockAuthenticationUtilHelper.setup(this.mockedAuthenticationUtil);
        Mockito.when((Object)this.mockedNodeService.getProperty(this.rmSite, ContentModel.PROP_NAME)).thenReturn((Object)"RM");
        Mockito.when((Object)this.mockedNodeService.getProperty(this.rmCategory, ContentModel.PROP_NAME)).thenReturn((Object)"C1");
        Mockito.when((Object)this.mockedNodeService.getProperty(this.rmFilePlan, ContentModel.PROP_NAME)).thenReturn((Object)"fileplan");
        Mockito.when((Object)this.mockedNodeService.getType(this.rmSite)).thenReturn((Object)RecordsManagementModel.TYPE_RM_SITE);
        Mockito.when((Object)this.mockedNodeService.getType(this.rmFilePlan)).thenReturn((Object)RecordsManagementModel.TYPE_FILE_PLAN);
        Mockito.when((Object)this.mockedNodeService.getType(this.rmCategory)).thenReturn((Object)RecordsManagementModel.TYPE_RECORD_CATEGORY);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(RecordsManagementModel.TYPE_RM_SITE, SiteModel.TYPE_SITE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(RecordsManagementModel.TYPE_FILE_PLAN, SiteModel.TYPE_SITE)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(RecordsManagementModel.TYPE_RECORD_CATEGORY, SiteModel.TYPE_SITE)).thenReturn((Object)false);
        ChildAssociationRef filePlanParentAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rmSite, QName.createQName((String)GUID.generate()), this.rmFilePlan);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(this.rmFilePlan)).thenReturn((Object)filePlanParentAssoc);
        ChildAssociationRef categoryParentAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.rmFilePlan, QName.createQName((String)GUID.generate()), this.rmCategory);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(this.rmCategory)).thenReturn((Object)categoryParentAssoc);
    }

    @Test
    public void testGetPathFromRMSite() {
        String rmSitePath = this.extendedImapServiceImpl.getPathFromSites(this.rmSite);
        Assert.assertEquals((String)"Incorrect return value", (Object)"RM".toLowerCase(), (Object)rmSitePath);
    }

    @Test
    public void testGetPathFromRMCategory() {
        String rmCategoryPath = this.extendedImapServiceImpl.getPathFromSites(this.rmCategory);
        Assert.assertEquals((String)"Incorrect return value", (Object)"RM/fileplan/C1".toLowerCase(), (Object)rmCategoryPath);
    }
}

