/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.transfer;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;

public class CreateTransferFolderAsNonAdminUserTest
extends BaseRMTestCase {
    private String testUser = null;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        this.testUser = GUID.generate();
        this.createPerson(this.testUser);
        this.siteService.setMembership(this.siteId, this.testUser, "SiteConsumer");
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", this.testUser);
    }

    public void testCreateTransferFolderAsNonAdminUser() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.testUser){
            private NodeRef recordsFolder;
            private NodeRef transferFolder;
            {
                this.recordsFolder = null;
                this.transferFolder = null;
            }

            @Override
            public void given() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() {
                        NodeRef category = CreateTransferFolderAsNonAdminUserTest.this.filePlanService.createRecordCategory(CreateTransferFolderAsNonAdminUserTest.this.filePlan, GUID.generate());
                        CreateTransferFolderAsNonAdminUserTest.this.filePlanPermissionService.setPermission(category, CreateTransferFolderAsNonAdminUserTest.this.testUser, "Filing");
                        CreateTransferFolderAsNonAdminUserTest.this.utils.createDispositionSchedule(category, "disposition instructions", "disposition authority", false, true, true);
                        recordsFolder = CreateTransferFolderAsNonAdminUserTest.this.recordFolderService.createRecordFolder(category, GUID.generate());
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("eventName", "case_closed");
                        CreateTransferFolderAsNonAdminUserTest.this.rmActionService.executeRecordsManagementAction(recordsFolder, "completeEvent", params);
                        CreateTransferFolderAsNonAdminUserTest.this.rmActionService.executeRecordsManagementAction(recordsFolder, "cutoff");
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
                this.transferFolder = (NodeRef)CreateTransferFolderAsNonAdminUserTest.this.rmActionService.executeRecordsManagementAction(this.recordsFolder, "transfer").getValue();
            }

            @Override
            public void when() {
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.transferFolder);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateTransferFolderAsNonAdminUserTest.this.permissionService.hasPermission(CreateTransferFolderAsNonAdminUserTest.this.transfersContainer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateTransferFolderAsNonAdminUserTest.this.permissionService.hasPermission(this.transferFolder, "Filing"));
            }
        });
    }
}

