/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import java.util.List;

class RolesFilter {
    private String personId;
    private boolean includeSystemRoles;
    private List<String> capabilities;

    private RolesFilter() {
    }

    public static RolesFilterBuilder builder() {
        return new RolesFilterBuilder();
    }

    public String getPersonId() {
        return this.personId;
    }

    public boolean includeSystemRoles() {
        return this.includeSystemRoles;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public static class RolesFilterBuilder {
        private String personId;
        private boolean includeSystemRoles = true;
        private List<String> capabilities;

        public RolesFilterBuilder withPersonId(String personId) {
            this.personId = personId;
            return this;
        }

        public RolesFilterBuilder withIncludeSystemRoles(Boolean includeSystemRoles) {
            if (includeSystemRoles != null) {
                this.includeSystemRoles = includeSystemRoles;
            }
            return this;
        }

        public RolesFilterBuilder withCapabilities(List<String> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public RolesFilter build() {
            RolesFilter rolesFilter = new RolesFilter();
            rolesFilter.personId = this.personId;
            rolesFilter.includeSystemRoles = this.includeSystemRoles;
            rolesFilter.capabilities = this.capabilities;
            return rolesFilter;
        }
    }
}

