/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.policy;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.acegisecurity.ConfigAttribute;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class ConfigAttributeDefinition {
    public static final String RM = "RM";
    public static final String RM_ALLOW = "RM_ALLOW";
    public static final String RM_DENY = "RM_DENY";
    public static final String RM_CAP = "RM_CAP";
    public static final String RM_ABSTAIN = "RM_ABSTAIN";
    public static final String RM_QUERY = "RM_QUERY";
    private String typeString;
    private String policyName;
    private SimplePermissionReference required;
    private Map<Integer, Integer> parameters = new HashMap<Integer, Integer>(2, 1.0f);
    private boolean parent = false;

    public ConfigAttributeDefinition(ConfigAttribute attr, NamespacePrefixResolver namespacePrefixResolver) {
        StringTokenizer st = new StringTokenizer(attr.getAttribute(), ".", false);
        if (st.countTokens() < 1) {
            throw new ACLEntryVoterException("There must be at least one token in a config attribute");
        }
        this.typeString = st.nextToken();
        if (!(this.typeString.equals(RM) || this.typeString.equals(RM_ALLOW) || this.typeString.equals(RM_CAP) || this.typeString.equals(RM_DENY) || this.typeString.equals(RM_QUERY) || this.typeString.equals(RM_ABSTAIN))) {
            throw new ACLEntryVoterException("Invalid type: must be ACL_NODE, ACL_PARENT or ACL_ALLOW");
        }
        if (this.typeString.equals(RM)) {
            this.policyName = st.nextToken();
            int position = 0;
            while (st.hasMoreElements()) {
                String numberString = st.nextToken();
                Integer value = Integer.parseInt(numberString);
                this.parameters.put(position, value);
                ++position;
            }
        } else if (this.typeString.equals(RM_CAP)) {
            String numberString = st.nextToken();
            String qNameString = st.nextToken();
            String permissionString = st.nextToken();
            Integer value = Integer.parseInt(numberString);
            this.parameters.put(0, value);
            QName qName = QName.createQName((String)qNameString, (NamespacePrefixResolver)namespacePrefixResolver);
            this.required = SimplePermissionReference.getPermissionReference((QName)qName, (String)permissionString);
            if (st.hasMoreElements()) {
                this.parent = true;
            }
        }
    }

    public String getTypeString() {
        return this.typeString;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public SimplePermissionReference getRequired() {
        return this.required;
    }

    public Map<Integer, Integer> getParameters() {
        return this.parameters;
    }

    public boolean isParent() {
        return this.parent;
    }
}

