/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.search.SortItem;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@AlfrescoPublicApi
public class RecordsManagementSearchParameters {
    private static final List<SortItem> DEFAULT_SORT_ORDER = new ArrayList<SortItem>(){
        {
            this.add(new SortItem(ContentModel.PROP_NAME, Boolean.TRUE));
        }
    };
    private static final Map<String, String> DEFAULT_TEMPLATES = new HashMap<String, String>(){
        {
            this.put("keywords", "%(cm:name cm:title cm:description TEXT)");
            this.put("name", "%(cm:name)");
            this.put("title", "%(cm:title)");
            this.put("description", "%(cm:description)");
            this.put("creator", "%(cm:creator)");
            this.put("created", "%(cm:created)");
            this.put("modifier", "%(cm:modifier)");
            this.put("modified", "%(cm:modified)");
            this.put("author", "%(cm:author)");
            this.put("markings", "%(rmc:supplementalMarkingList)");
            this.put("dispositionEvents", "%(rma:recordSearchDispositionEvents)");
            this.put("dispositionActionName", "%(rma:recordSearchDispositionActionName)");
            this.put("dispositionActionAsOf", "%(rma:recordSearchDispositionActionAsOf)");
            this.put("dispositionEventsEligible", "%(rma:recordSearchDispositionEventsEligible)");
            this.put("dispositionPeriod", "%(rma:recordSearchDispositionPeriod)");
            this.put("hasDispositionSchedule", "%(rma:recordSearchHasDispositionSchedule)");
            this.put("dispositionInstructions", "%(rma:recordSearchDispositionInstructions)");
            this.put("dispositionAuthority", "%(rma:recordSearchDispositionAuthority)");
            this.put("vitalRecordReviewPeriod", "%(rma:recordSearchVitalRecordReviewPeriod)");
        }
    };
    private static final List<QName> DEFAULT_INCLUDED_CONTAINER_TYPES = Collections.emptyList();
    private int maxItems;
    private boolean includeRecords = true;
    private boolean includeUndeclaredRecords = false;
    private boolean includeVitalRecords = false;
    private boolean includeRecordFolders = true;
    private boolean includeFrozen = false;
    private boolean includeCutoff = false;
    private List<QName> includedContainerTypes = DEFAULT_INCLUDED_CONTAINER_TYPES;
    private List<SortItem> sortOrder = DEFAULT_SORT_ORDER;
    private Map<String, String> templates = DEFAULT_TEMPLATES;
    private static final String JSON_MAXITEMS = "maxitems";
    private static final String JSON_RECORDS = "records";
    private static final String JSON_UNDECLAREDRECORDS = "undeclaredrecords";
    private static final String JSON_VITALRECORDS = "vitalrecords";
    private static final String JSON_RECORDFOLDERES = "recordfolders";
    private static final String JSON_FROZEN = "frozen";
    private static final String JSON_CUTOFF = "cutoff";
    private static final String JSON_CONTAINERTYPES = "containertypes";
    private static final String JSON_SORT = "sort";
    private static final String JSON_FIELD = "field";
    private static final String JSON_ASCENDING = "ascending";

    public static RecordsManagementSearchParameters createFromJSON(String json, NamespaceService namespaceService) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            return RecordsManagementSearchParameters.createFromJSON(jsonObject, namespaceService);
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Unable to create records management search parameters from json string.  " + json, (Throwable)e);
        }
    }

    public static RecordsManagementSearchParameters createFromJSON(JSONObject jsonObject, NamespaceService namespaceService) {
        try {
            int i;
            JSONArray jsonArray;
            RecordsManagementSearchParameters searchParameters = new RecordsManagementSearchParameters();
            if (jsonObject.has(JSON_MAXITEMS)) {
                searchParameters.setMaxItems(jsonObject.getInt(JSON_MAXITEMS));
            }
            if (jsonObject.has(JSON_RECORDS)) {
                searchParameters.setIncludeRecords(jsonObject.getBoolean(JSON_RECORDS));
            }
            if (jsonObject.has(JSON_UNDECLAREDRECORDS)) {
                searchParameters.setIncludeUndeclaredRecords(jsonObject.getBoolean(JSON_UNDECLAREDRECORDS));
            }
            if (jsonObject.has(JSON_VITALRECORDS)) {
                searchParameters.setIncludeVitalRecords(jsonObject.getBoolean(JSON_VITALRECORDS));
            }
            if (jsonObject.has(JSON_RECORDFOLDERES)) {
                searchParameters.setIncludeRecordFolders(jsonObject.getBoolean(JSON_RECORDFOLDERES));
            }
            if (jsonObject.has(JSON_FROZEN)) {
                searchParameters.setIncludeFrozen(jsonObject.getBoolean(JSON_FROZEN));
            }
            if (jsonObject.has(JSON_CUTOFF)) {
                searchParameters.setIncludeCutoff(jsonObject.getBoolean(JSON_CUTOFF));
            }
            if (jsonObject.has(JSON_CONTAINERTYPES)) {
                jsonArray = jsonObject.getJSONArray(JSON_CONTAINERTYPES);
                ArrayList<QName> containerTypes = new ArrayList<QName>(jsonArray.length());
                for (i = 0; i < jsonArray.length(); ++i) {
                    String type = jsonArray.getString(i);
                    containerTypes.add(QName.createQName((String)type, (NamespacePrefixResolver)namespaceService));
                }
                searchParameters.setIncludedContainerTypes(containerTypes);
            }
            if (jsonObject.has(JSON_SORT)) {
                jsonArray = jsonObject.getJSONArray(JSON_SORT);
                ArrayList<SortItem> sortOrder = new ArrayList<SortItem>(jsonArray.length());
                for (i = 0; i < jsonArray.length(); ++i) {
                    JSONObject sortJSONObject = jsonArray.getJSONObject(i);
                    if (!sortJSONObject.has(JSON_FIELD) || !sortJSONObject.has(JSON_ASCENDING)) continue;
                    sortOrder.add(new SortItem(QName.createQName((String)sortJSONObject.getString(JSON_FIELD), (NamespacePrefixResolver)namespaceService), sortJSONObject.getBoolean(JSON_ASCENDING)));
                }
                searchParameters.setSortOrder(sortOrder);
            }
            return searchParameters;
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Unable to create records management search parameters from json string.  " + jsonObject.toString(), (Throwable)e);
        }
    }

    public String toJSONString(NamespaceService namespaceService) {
        return this.toJSONObject(namespaceService).toString();
    }

    public JSONObject toJSONObject(NamespaceService namespaceService) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(JSON_MAXITEMS, this.maxItems);
            jsonObject.put(JSON_RECORDS, this.includeRecords);
            jsonObject.put(JSON_UNDECLAREDRECORDS, this.includeUndeclaredRecords);
            jsonObject.put(JSON_VITALRECORDS, this.includeVitalRecords);
            jsonObject.put(JSON_RECORDFOLDERES, this.includeRecordFolders);
            jsonObject.put(JSON_FROZEN, this.includeFrozen);
            jsonObject.put(JSON_CUTOFF, this.includeCutoff);
            JSONArray jsonArray = new JSONArray();
            for (QName containerType : this.includedContainerTypes) {
                jsonArray.put((Object)containerType.toPrefixString((NamespacePrefixResolver)namespaceService));
            }
            jsonObject.put(JSON_CONTAINERTYPES, (Object)jsonArray);
            JSONArray jsonSortArray = new JSONArray();
            for (SortItem entry : this.sortOrder) {
                JSONObject jsonEntry = new JSONObject();
                jsonEntry.put(JSON_FIELD, (Object)entry.property.toPrefixString((NamespacePrefixResolver)namespaceService));
                jsonEntry.put(JSON_ASCENDING, entry.assc);
                jsonSortArray.put((Object)jsonEntry);
            }
            jsonObject.put(JSON_SORT, (Object)jsonSortArray);
            return jsonObject;
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Unable to generate json string for records management search parameters.", (Throwable)e);
        }
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setSortOrder(List<SortItem> sortOrder) {
        this.sortOrder = sortOrder;
    }

    public List<SortItem> getSortOrder() {
        return this.sortOrder;
    }

    public void setTemplates(Map<String, String> templates) {
        this.templates = templates;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public void setIncludeRecords(boolean includeRecords) {
        this.includeRecords = includeRecords;
    }

    public boolean isIncludeRecords() {
        return this.includeRecords;
    }

    public void setIncludeUndeclaredRecords(boolean includeUndeclaredRecords) {
        this.includeUndeclaredRecords = includeUndeclaredRecords;
    }

    public boolean isIncludeUndeclaredRecords() {
        return this.includeUndeclaredRecords;
    }

    public void setIncludeVitalRecords(boolean includeVitalRecords) {
        this.includeVitalRecords = includeVitalRecords;
    }

    public boolean isIncludeVitalRecords() {
        return this.includeVitalRecords;
    }

    public void setIncludeRecordFolders(boolean includeRecordFolders) {
        this.includeRecordFolders = includeRecordFolders;
    }

    public boolean isIncludeRecordFolders() {
        return this.includeRecordFolders;
    }

    public void setIncludeFrozen(boolean includeFrozen) {
        this.includeFrozen = includeFrozen;
    }

    public boolean isIncludeFrozen() {
        return this.includeFrozen;
    }

    public void setIncludeCutoff(boolean includeCutoff) {
        this.includeCutoff = includeCutoff;
    }

    public boolean isIncludeCutoff() {
        return this.includeCutoff;
    }

    public void setIncludedContainerTypes(List<QName> includedContainerTypes) {
        this.includedContainerTypes = includedContainerTypes;
    }

    public List<QName> getIncludedContainerTypes() {
        return this.includedContainerTypes;
    }
}

