/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.unfiledrecordfolders;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.impl.SearchTypesFactory;
import org.alfresco.rm.rest.api.model.UnfiledRecordFolder;
import org.alfresco.rm.rest.api.model.UnfiledRecordFolderChild;
import org.alfresco.rm.rest.api.model.UploadInfo;
import org.alfresco.rm.rest.api.unfiledrecordfolders.UnfiledRecordFolderEntityResource;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.servlet.FormData;

@RelationshipResource(name="children", entityResource=UnfiledRecordFolderEntityResource.class, title="Children of an unfiled record folder")
public class UnfiledRecordFolderChildrenRelation
implements RelationshipResourceAction.Read<UnfiledRecordFolderChild>,
RelationshipResourceAction.Create<UnfiledRecordFolderChild>,
MultiPartRelationshipResourceAction.Create<UnfiledRecordFolderChild> {
    private static final Set<String> LIST_UNFILED_RECORD_FOLDER_CHILDREN_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("isUnfiledRecordFolder", "isRecord", "nodeType"));
    private FilePlanComponentsApiUtils apiUtils;
    private SearchTypesFactory searchTypesFactory;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setSearchTypesFactory(SearchTypesFactory searchTypesFactory) {
        this.searchTypesFactory = searchTypesFactory;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @WebApiDescription(title="Return a paged list of unfiled container children for the container identified by 'unfiledContainerId'")
    public CollectionWithPagingInfo<UnfiledRecordFolderChild> readAll(String unfileRecordFolderId, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfileRecordFolderId", unfileRecordFolderId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        String relativePath = parameters.getParameter("relativePath");
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(unfileRecordFolderId, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER, relativePath, true);
        Set<QName> searchTypeQNames = this.searchTypesFactory.buildSearchTypesForUnfiledEndpoint(parameters, LIST_UNFILED_RECORD_FOLDER_CHILDREN_EQUALS_QUERY_PROPERTIES);
        PagingResults pagingResults = this.fileFolderService.list(parentNodeRef, null, searchTypeQNames, null, this.apiUtils.getSortProperties(parameters), null, Util.getPagingRequest((Paging)parameters.getPaging()));
        final List page = pagingResults.getPage();
        final HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        AbstractList<UnfiledRecordFolderChild> nodes = new AbstractList<UnfiledRecordFolderChild>(){

            @Override
            public UnfiledRecordFolderChild get(int index) {
                FileInfo info = (FileInfo)page.get(index);
                return UnfiledRecordFolderChildrenRelation.this.nodesModelFactory.createUnfiledRecordFolderChild(info, parameters, mapUserInfo, true);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        UnfiledRecordFolder sourceEntity = null;
        if (parameters.includeSource()) {
            FileInfo info = this.fileFolderService.getFileInfo(parentNodeRef);
            sourceEntity = this.nodesModelFactory.createUnfiledRecordFolder(info, parameters, mapUserInfo, true);
        }
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)nodes, (boolean)pagingResults.hasMoreItems(), (Integer)((Integer)pagingResults.getTotalResultCount().getFirst()), sourceEntity);
    }

    @WebApiDescription(title="Create one (or more) nodes as children of a unfiled record folder identified by 'unfiledRecordFolderId'")
    public List<UnfiledRecordFolderChild> create(String unfiledRecordFolderId, final List<UnfiledRecordFolderChild> nodeInfos, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledRecordFolderId", unfiledRecordFolderId);
        ParameterCheck.mandatory((String)"nodeInfos", nodeInfos);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledRecordFolderId, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER);
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() {
                LinkedList<NodeRef> createdNodes = new LinkedList<NodeRef>();
                for (UnfiledRecordFolderChild nodeInfo : nodeInfos) {
                    NodeRef nodeParent = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nodeInfo.getRelativePath()}) ? UnfiledRecordFolderChildrenRelation.this.apiUtils.lookupAndValidateRelativePath(parentNodeRef, nodeInfo.getRelativePath(), RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER) : parentNodeRef;
                    NodeRef newNodeRef = UnfiledRecordFolderChildrenRelation.this.apiUtils.createRMNode(nodeParent, nodeInfo, parameters);
                    createdNodes.add(newNodeRef);
                }
                return createdNodes;
            }
        };
        List createdNodes = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        LinkedList<UnfiledRecordFolderChild> result = new LinkedList<UnfiledRecordFolderChild>();
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        for (NodeRef newNodeRef : createdNodes) {
            FileInfo info = this.fileFolderService.getFileInfo(newNodeRef);
            this.apiUtils.postActivity(info, parentNodeRef, "org.alfresco.documentlibrary.file-added");
            result.add(this.nodesModelFactory.createUnfiledRecordFolderChild(info, parameters, mapUserInfo, false));
        }
        return result;
    }

    @WebApiDescription(title="Upload file content and meta-data into the repository.")
    @WebApiParam(name="formData", title="A single form data", description="A single form data which holds FormFields.")
    public UnfiledRecordFolderChild create(final String unfiledRecordFolderId, FormData formData, final Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("unfiledRecordFolderId", unfiledRecordFolderId);
        ParameterCheck.mandatory((String)"formData", (Object)formData);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final UploadInfo uploadInfo = new UploadInfo(formData);
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

            public Pair<NodeRef, NodeRef> execute() {
                NodeRef parentNodeRef = UnfiledRecordFolderChildrenRelation.this.apiUtils.lookupAndValidateNodeType(unfiledRecordFolderId, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER, uploadInfo.getRelativePath());
                NodeRef newNode = UnfiledRecordFolderChildrenRelation.this.apiUtils.uploadRecord(parentNodeRef, uploadInfo, parameters);
                return new Pair((Object)newNode, (Object)parentNodeRef);
            }
        };
        Pair nodeAndParentInfo = (Pair)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        NodeRef newNode = (NodeRef)nodeAndParentInfo.getFirst();
        NodeRef parent = (NodeRef)nodeAndParentInfo.getSecond();
        FileInfo info = this.fileFolderService.getFileInfo(newNode);
        this.apiUtils.postActivity(info, parent, "org.alfresco.documentlibrary.file-added");
        return this.nodesModelFactory.createUnfiledRecordFolderChild(info, parameters, null, false);
    }
}

