/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit.extractor;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public final class AuthenticatedUserRolesDataExtractor
extends AbstractDataExtractor {
    private NodeService nodeService;
    private FilePlanService filePlanService;
    private FilePlanRoleService filePlanRoleService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public boolean isSupported(Serializable data) {
        if (!(data instanceof NodeRef)) {
            return false;
        }
        NodeRef nodeRef = (NodeRef)data;
        return this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT) || this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_CONTENT);
    }

    public Serializable extractData(Serializable value) {
        NodeRef nodeRef = (NodeRef)value;
        String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (user == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        NodeRef rmRootNodeRef = this.filePlanService.getFilePlan(nodeRef);
        if (rmRootNodeRef == null && this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_CONTENT)) {
            rmRootNodeRef = this.filePlanService.getFilePlanBySiteId("rm");
        }
        if (rmRootNodeRef != null) {
            Set<Role> roles = this.filePlanRoleService.getRolesByUser(rmRootNodeRef, user);
            for (Role role : roles) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(role.getDisplayLabel());
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticatedUserRolesDataExtractor that = (AuthenticatedUserRolesDataExtractor)((Object)o);
        return Objects.equals(this.nodeService, that.nodeService) && Objects.equals(this.filePlanService, that.filePlanService) && Objects.equals(this.filePlanRoleService, that.filePlanRoleService);
    }

    public int hashCode() {
        return Objects.hash(this.nodeService, this.filePlanService, this.filePlanRoleService);
    }
}

